/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.input;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.io.input.InputCoverageGoal;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputObserver
extends ExecutionObserver {
    private Map<Integer, Set<InputCoverageGoal>> inputCoverage = new LinkedHashMap<Integer, Set<InputCoverageGoal>>();
    private static final Logger logger = LoggerFactory.getLogger(InputObserver.class);

    @Override
    public void output(int position, String output) {
    }

    @Override
    public void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (statement instanceof EntityWithParametersStatement) {
            EntityWithParametersStatement parameterisedStatement = (EntityWithParametersStatement)statement;
            List<VariableReference> parRefs = parameterisedStatement.getParameterReferences();
            ArrayList<Object> argObjects = new ArrayList<Object>(parRefs.size());
            for (VariableReference parRef : parRefs) {
                Object parObject = null;
                try {
                    parObject = parRef instanceof ArrayIndex || parRef instanceof FieldReference ? parRef.getObject(scope) : (parRef instanceof ConstantValue ? ((ConstantValue)parRef).getValue() : parRef.getObject(scope));
                }
                catch (CodeUnderTestException e) {
                    e.printStackTrace();
                }
                argObjects.add(parObject);
            }
            assert (parRefs.size() == argObjects.size());
            String className = parameterisedStatement.getDeclaringClassName();
            String methodDesc = parameterisedStatement.getDescriptor();
            String methodName = parameterisedStatement.getMethodName();
            this.inputCoverage.put(statement.getPosition(), InputCoverageGoal.createCoveredGoalsFromParameters(className, methodName, methodDesc, argObjects));
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
        logger.info("Attaching argumentsValues map to ExecutionResult");
        r.setInputGoals(this.inputCoverage);
    }

    @Override
    public void clear() {
        logger.info("Clearing InputObserver data");
        this.inputCoverage = new LinkedHashMap<Integer, Set<InputCoverageGoal>>();
    }
}

