/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.line.LineCoverageFactory;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyLineCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -6369027784777941998L;
    private static final Logger logger = LoggerFactory.getLogger(OnlyLineCoverageSuiteFitness.class);
    private final Map<Integer, TestFitnessFunction> lineGoals = new LinkedHashMap<Integer, TestFitnessFunction>();
    private final int numLines;
    private final Set<Integer> removedLines = new LinkedHashSet<Integer>();
    private final Set<Integer> toRemoveLines = new LinkedHashSet<Integer>();
    private int maxCoveredLines = 0;
    private double bestFitness = Double.MAX_VALUE;

    public OnlyLineCoverageSuiteFitness() {
        String prefix = Properties.TARGET_CLASS_PREFIX;
        List<LineCoverageTestFitness> goals = new LineCoverageFactory().getCoverageGoals();
        for (LineCoverageTestFitness goal : goals) {
            this.lineGoals.put(goal.getLine(), goal);
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().addTarget(goal);
        }
        this.numLines = this.lineGoals.size();
        logger.info("Total line coverage goals: " + this.numLines);
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (Integer goalID : this.toRemoveLines) {
            TestFitnessFunction ff = this.lineGoals.remove(goalID);
            if (ff != null) {
                this.removedLines.add(goalID);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveLines.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        assert (this.numLines == this.lineGoals.size() + this.removedLines.size());
        return true;
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Set<Integer> coveredLines) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
                continue;
            }
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (Integer goalID : this.lineGoals.keySet()) {
                TestFitnessFunction goal = this.lineGoals.get(goalID);
                double fit = goal.getFitness(test, result);
                if (fit != 0.0) continue;
                coveredLines.add(goalID);
                this.toRemoveLines.add(goalID);
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        LinkedHashSet<Integer> coveredLines = new LinkedHashSet<Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, coveredLines);
        int totalLines = this.numLines;
        int numCoveredLines = coveredLines.size() + this.removedLines.size();
        logger.debug("Covered " + numCoveredLines + " out of " + totalLines + " lines, " + this.removedLines.size() + " in archive");
        this.printStatusMessages(suite, numCoveredLines, fitness += OnlyLineCoverageSuiteFitness.normalize(totalLines - numCoveredLines));
        if (totalLines > 0) {
            suite.setCoverage(this, (double)numCoveredLines / (double)totalLines);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, numCoveredLines);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + totalLines);
            fitness = totalLines;
        }
        this.updateIndividual(suite, fitness);
        assert (numCoveredLines <= totalLines) : "Covered " + numCoveredLines + " vs total goals " + totalLines;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || numCoveredLines == totalLines) : "Fitness: " + fitness + ", coverage: " + numCoveredLines + "/" + totalLines;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(TestSuiteChromosome suite, int coveredLines, double fitness) {
        if (coveredLines > this.maxCoveredLines) {
            this.maxCoveredLines = coveredLines;
            logger.info("(Lines) Best individual covers " + coveredLines + "/" + this.numLines + " lines");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredLines + "/" + this.numLines + " lines");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

