/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;

public class MutationPool {
    private static Map<ClassLoader, MutationPool> instanceMap = new HashMap<ClassLoader, MutationPool>();
    private Map<String, Map<String, List<Mutation>>> mutationMap = new LinkedHashMap<String, Map<String, List<Mutation>>>();
    private Map<Integer, Mutation> mutationIdMap = new LinkedHashMap<Integer, Mutation>();
    private int numMutations = 0;

    public static MutationPool getInstance(ClassLoader classLoader) {
        if (!instanceMap.containsKey(classLoader)) {
            instanceMap.put(classLoader, new MutationPool());
        }
        return instanceMap.get(classLoader);
    }

    private MutationPool() {
    }

    public Mutation addMutation(String className, String methodName, String mutationName, BytecodeInstruction instruction, AbstractInsnNode mutation, InsnList distance) {
        if (!this.mutationMap.containsKey(className)) {
            this.mutationMap.put(className, new HashMap());
        }
        if (!this.mutationMap.get(className).containsKey(methodName)) {
            this.mutationMap.get(className).put(methodName, new ArrayList());
        }
        Mutation mutationObject = new Mutation(className, methodName, mutationName, this.numMutations++, instruction, mutation, distance);
        this.mutationMap.get(className).get(methodName).add(mutationObject);
        this.mutationIdMap.put(mutationObject.getId(), mutationObject);
        return mutationObject;
    }

    public Mutation addMutation(String className, String methodName, String mutationName, BytecodeInstruction instruction, InsnList mutation, InsnList distance) {
        if (!this.mutationMap.containsKey(className)) {
            this.mutationMap.put(className, new HashMap());
        }
        if (!this.mutationMap.get(className).containsKey(methodName)) {
            this.mutationMap.get(className).put(methodName, new ArrayList());
        }
        Mutation mutationObject = new Mutation(className, methodName, mutationName, this.numMutations++, instruction, mutation, distance);
        this.mutationMap.get(className).get(methodName).add(mutationObject);
        this.mutationIdMap.put(mutationObject.getId(), mutationObject);
        return mutationObject;
    }

    public List<Mutation> retrieveMutationsInMethod(String className, String methodName) {
        ArrayList<Mutation> r = new ArrayList<Mutation>();
        if (this.mutationMap.get(className) == null) {
            return r;
        }
        List<Mutation> mutants = this.mutationMap.get(className).get(methodName);
        if (mutants != null) {
            r.addAll(mutants);
        }
        return r;
    }

    public List<Mutation> getMutants() {
        return new ArrayList<Mutation>(this.mutationIdMap.values());
    }

    public Mutation getMutant(int id) {
        return this.mutationIdMap.get(id);
    }

    public void clear() {
        this.mutationMap.clear();
        this.mutationIdMap.clear();
        this.numMutations = 0;
    }

    public int getMutantCounter() {
        return this.numMutations;
    }
}

