/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationSuiteFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;

public class OnlyMutationSuiteFitness
extends MutationSuiteFitness {
    private static final long serialVersionUID = -8194940669364526758L;

    public OnlyMutationSuiteFitness() {
        super(Properties.Criterion.ONLYMUTATION);
    }

    @Override
    public double getFitness(TestSuiteChromosome individual) {
        if (this.numMutants == 0) {
            this.updateIndividual(individual, 0.0);
            individual.setCoverage(this, 1.0);
            individual.setNumOfCoveredGoals(this, 0);
            return 0.0;
        }
        List<ExecutionResult> results = this.runTestSuite(individual);
        double fitness = 0.0;
        LinkedHashMap<Integer, Double> mutant_distance = new LinkedHashMap<Integer, Double>();
        LinkedHashSet<Integer> touchedMutants = new LinkedHashSet<Integer>();
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException() || result.calledReflection()) continue;
            touchedMutants.addAll(result.getTrace().getTouchedMutants());
            Map<Integer, Double> touchedMutantsDistances = result.getTrace().getMutationDistances();
            if (touchedMutantsDistances.isEmpty()) continue;
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (Map.Entry entry : this.mutantMap.entrySet()) {
                int mutantID = (Integer)entry.getKey();
                TestFitnessFunction goal = (TestFitnessFunction)entry.getValue();
                double fit = 0.0;
                if (touchedMutantsDistances.containsKey(mutantID)) {
                    fit = touchedMutantsDistances.get(mutantID);
                    if (!mutant_distance.containsKey(mutantID)) {
                        mutant_distance.put(mutantID, fit);
                    } else {
                        mutant_distance.put(mutantID, Math.min((Double)mutant_distance.get(mutantID), fit));
                    }
                } else {
                    fit = goal.getFitness(test, result);
                }
                if (fit == 0.0) {
                    test.getTestCase().addCoveredGoal(goal);
                    this.toRemoveMutants.add(mutantID);
                }
                if (!Properties.TEST_ARCHIVE) continue;
                Archive.getArchiveInstance().updateArchive(goal, test, fit);
            }
        }
        fitness += (double)(MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getMutantCounter() - touchedMutants.size());
        int covered = this.removedMutants.size();
        for (Double distance : mutant_distance.values()) {
            if (distance < 0.0) {
                logger.warn("Distance is " + distance + " / " + Integer.MAX_VALUE + " / " + Integer.MIN_VALUE);
                distance = 0.0;
            }
            fitness += OnlyMutationSuiteFitness.normalize(distance);
            if (distance != 0.0) continue;
            ++covered;
        }
        this.updateIndividual(individual, fitness);
        individual.setCoverage(this, (double)covered / (double)this.numMutants);
        individual.setNumOfCoveredGoals(this, covered);
        return fitness;
    }
}

