/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.rho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.rho.RhoCoverageFactory;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class RhoCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = -1483213330289592274L;
    private int previous_number_of_ones = 0;
    private int previous_number_of_test_cases = 0;
    private Set<Set<Integer>> coverage_matrix_generated_so_far = new LinkedHashSet<Set<Integer>>();

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        LinkedHashSet<Set<Integer>> tmp_coverage_matrix = new LinkedHashSet<Set<Integer>>(this.coverage_matrix_generated_so_far);
        double fitness = 1.0;
        int number_of_goals = RhoCoverageFactory.getNumberGoals();
        int number_of_ones = RhoCoverageFactory.getNumber_of_Ones() + this.previous_number_of_ones;
        int number_of_test_cases = RhoCoverageFactory.getNumber_of_Test_Cases() + this.previous_number_of_test_cases;
        Set<Integer> coveredLines = result.getTrace().getCoveredLines();
        if (Properties.STRATEGY == Properties.Strategy.ENTBUG) {
            ArrayList<Integer> l_coveredLines = new ArrayList<Integer>(coveredLines);
            Collections.sort(l_coveredLines);
            LinkedHashSet<Integer> coveredLinesOrdered = new LinkedHashSet<Integer>(l_coveredLines);
            if (coveredLinesOrdered.size() == 0) {
                this.updateIndividual(individual, 1.0);
                return 1.0;
            }
            if (!tmp_coverage_matrix.add(coveredLinesOrdered)) {
                this.updateIndividual(individual, 1.0);
                return 1.0;
            }
            if (RhoCoverageFactory.exists(l_coveredLines)) {
                this.updateIndividual(individual, 1.0);
                return 1.0;
            }
            number_of_ones += coveredLinesOrdered.size();
            ++number_of_test_cases;
        } else {
            number_of_ones += coveredLines.size();
            ++number_of_test_cases;
        }
        if ((double)number_of_test_cases == 0.0) {
            fitness = 1.0;
        } else {
            fitness = (double)number_of_ones / (double)number_of_test_cases / (double)number_of_goals;
            fitness = Math.abs(0.5 - fitness);
        }
        this.updateIndividual(individual, fitness);
        return fitness;
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        return this.compareClassName(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coverage_matrix_generated_so_far == null ? 0 : this.coverage_matrix_generated_so_far.hashCode());
        result = 31 * result + this.previous_number_of_ones;
        result = 31 * result + this.previous_number_of_test_cases;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RhoCoverageTestFitness other = (RhoCoverageTestFitness)obj;
        if (this.coverage_matrix_generated_so_far == null ? other.coverage_matrix_generated_so_far != null : !this.coverage_matrix_generated_so_far.equals(other.coverage_matrix_generated_so_far)) {
            return false;
        }
        if (this.previous_number_of_ones != other.previous_number_of_ones) {
            return false;
        }
        return this.previous_number_of_test_cases == other.previous_number_of_test_cases;
    }

    @Override
    public String getTargetClass() {
        return null;
    }

    @Override
    public String getTargetMethod() {
        return null;
    }

    public void incrementNumber_of_Ones(int n) {
        this.previous_number_of_ones += n;
    }

    public int getNumber_of_Ones() {
        return this.previous_number_of_ones;
    }

    public void incrementNumber_of_Test_Cases() {
        ++this.previous_number_of_test_cases;
    }

    public int getNumber_of_Test_Cases() {
        return this.previous_number_of_test_cases;
    }

    public void addTestCoverage(Set<Integer> test_coverage) {
        this.coverage_matrix_generated_so_far.add(test_coverage);
    }
}

