/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.statement;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.statement.StatementCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.testsuite.AbstractFitnessFactory;

public class StatementCoverageFactory
extends AbstractFitnessFactory<StatementCoverageTestFitness> {
    @Override
    public List<StatementCoverageTestFitness> getCoverageGoals() {
        long start = System.currentTimeMillis();
        String targetClass = Properties.TARGET_CLASS;
        ArrayList<StatementCoverageTestFitness> goals = new ArrayList<StatementCoverageTestFitness>();
        MethodNameMatcher matcher = new MethodNameMatcher();
        for (String className : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownClasses()) {
            if (!targetClass.equals("") && !className.endsWith(targetClass)) continue;
            for (String methodName : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownMethods(className)) {
                if (!matcher.methodMatches(methodName)) continue;
                for (BytecodeInstruction ins : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getInstructionsIn(className, methodName)) {
                    if (!StatementCoverageFactory.isUsable(ins)) continue;
                    goals.add(new StatementCoverageTestFitness(ins.getClassName(), ins.getMethodName(), ins.getInstructionId()));
                }
            }
        }
        long end = System.currentTimeMillis();
        goalComputationTime = end - start;
        return goals;
    }

    private static boolean isUsable(BytecodeInstruction ins) {
        return !ins.isLabel() && !ins.isLineNumber();
    }
}

