/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class StatementCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 5222436175279169394L;
    private final String className;
    private final String methodName;
    private final Integer instructionID;
    protected final List<BranchCoverageTestFitness> branchFitnesses = new ArrayList<BranchCoverageTestFitness>();
    protected transient BytecodeInstruction goalInstruction;

    public StatementCoverageTestFitness(BytecodeInstruction goalInstruction) {
        Objects.requireNonNull(goalInstruction);
        this.className = goalInstruction.getClassName();
        this.methodName = goalInstruction.getMethodName();
        this.instructionID = goalInstruction.getInstructionId();
        this.setupDependencies(goalInstruction);
    }

    public StatementCoverageTestFitness(String className, String methodName, Integer instructionID) {
        this.className = Objects.requireNonNull(className, "className cannot be null");
        this.methodName = Objects.requireNonNull(methodName, "methodName cannot be null");
        this.instructionID = Objects.requireNonNull(instructionID, "instructionID cannot be null");
        BytecodeInstruction goalInstruction = BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getInstruction(this.className, this.methodName, this.instructionID);
        this.setupDependencies(goalInstruction);
    }

    private void setupDependencies(BytecodeInstruction goalInstruction) {
        this.goalInstruction = goalInstruction;
        Set<ControlDependency> cds = goalInstruction.getControlDependencies();
        for (ControlDependency cd : cds) {
            BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
            this.branchFitnesses.add(fitness);
        }
        if (goalInstruction.isRootBranchDependent()) {
            this.branchFitnesses.add(BranchCoverageFactory.createRootBranchTestFitness(goalInstruction));
        }
        if (cds.isEmpty() && !goalInstruction.isRootBranchDependent()) {
            throw new IllegalStateException("expect control dependencies to be empty only for root dependent instructions: " + this.toString());
        }
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("an instruction is at least on the root branch of it's method");
        }
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("expect to know at least one fitness for goalInstruction");
        }
        if (result.hasTimeout() || result.hasTestException()) {
            this.updateIndividual(individual, Double.MAX_VALUE);
            return Double.MAX_VALUE;
        }
        double r = Double.MAX_VALUE;
        boolean archive = Properties.TEST_ARCHIVE;
        Properties.TEST_ARCHIVE = false;
        for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
            double newFitness = branchFitness.getFitness(individual, result);
            if (newFitness == 0.0) {
                r = 0.0;
                individual.getTestCase().removeCoveredGoal(branchFitness);
                break;
            }
            if (!(newFitness < r)) continue;
            r = newFitness;
        }
        Properties.TEST_ARCHIVE = archive;
        this.updateIndividual(individual, r);
        if (r == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, r);
        }
        return r;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("StatementCoverageTestFitness for ");
        r.append("\tClass: " + this.className);
        r.append("\tMethod: " + this.methodName);
        r.append("\tInstructionID: " + this.instructionID);
        r.append("\n");
        r.append("CDS:\n");
        for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
            r.append("\t" + branchFitness.toString());
        }
        return r.toString();
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other == null) {
            return 1;
        }
        if (other instanceof StatementCoverageTestFitness) {
            StatementCoverageTestFitness otherStatementFitness = (StatementCoverageTestFitness)other;
            if (this.getTargetClass().compareTo(otherStatementFitness.getTargetClass()) != 0) {
                return this.getTargetClass().compareTo(otherStatementFitness.getTargetClass());
            }
            if (this.getTargetMethod().compareTo(otherStatementFitness.getTargetMethod()) != 0) {
                return this.getTargetMethod().compareTo(otherStatementFitness.getTargetMethod());
            }
            if (this.instructionID.compareTo(otherStatementFitness.instructionID) != 0) {
                return this.instructionID - otherStatementFitness.instructionID;
            }
        }
        return this.compareClassName(other);
    }

    @Override
    public int hashCode() {
        int iConst = 13;
        return 663 + this.getTargetClass().hashCode() * 13 + this.getTargetMethod().hashCode() * 13 + this.instructionID * 13;
    }

    public List<BranchCoverageTestFitness> getBranchFitnesses() {
        return this.branchFitnesses;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementCoverageTestFitness other = (StatementCoverageTestFitness)obj;
        if (!this.className.equals(other.className)) {
            return false;
        }
        if (!this.methodName.equals(other.methodName)) {
            return false;
        }
        return this.instructionID.intValue() == other.instructionID.intValue();
    }

    @Override
    public String getTargetClass() {
        return this.className;
    }

    @Override
    public String getTargetMethod() {
        return this.methodName;
    }

    public BytecodeInstruction getGoalInstruction() {
        return this.goalInstruction;
    }
}

