/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.dse;

import org.evosuite.PackageInfo;
import org.evosuite.dse.Help;
import org.evosuite.dse.LinkedStringList;

public class MainConfig {
    private static MainConfig singleton;
    @Help(value="Do not instrument any of the classes that have any of these prefixes. IMPORTANT: InstrumentConfig maintains the same list. Both lists have to be updated for Dsc to work properly! TODO: Merge these two lists.")
    public LinkedStringList DO_NOT_INSTRUMENT_PREFIXES = new LinkedStringList("java.", "javax.", "sun.", "com.sun.", "$", "org.eclipse.", "org.junit.", "junit.", PackageInfo.getEvoSuitePackage() + ".", "edu.uta.cse.dbtest.", "edu.uta.cse.tada.", "edu.uta.cse.z3.", "org.evosuite.shaded.org.objectweb.asm.", "roops.util.", "org.evosuite.shaded.org.apache.derby.", "tada.sqlparser.", "Zql.", "org.jcp.", "org.postgresql.", "edu.umass.cs.", "com.yourkit.", "woda2010.", "com.accenture.lab.crest.vm.", "com.mysql.", "org.evosuite.shaded.org.apache.oro.text.regex.");
    @Help(value="Prefixes of classes that will always be explored symbolically, regardless if they appear in DO_NOT_INSTRUMENT_PREFIXES. IMPORTANT: InstrumentConfig maintains the same list. Both lists have to be updated for Dsc to work properly! TODO: Merge these two lists.")
    public LinkedStringList DO_INSTRUMENT_PREFIXES = new LinkedStringList("com.sun.javadoc.", "roops.util.RoopsArray");
    @Help(value="Artificial maximum number of local variables in a method/constructor")
    public int MAX_LOCALS_DEFAULT = 200;
    public final String CLINIT = "<clinit>";
    public final String INIT = "<init>";
    @Help(value="Class path for finding new classes")
    public String CLASS_PATH = System.getProperty("java.class.path");

    public static MainConfig get() {
        return singleton;
    }

    public static MainConfig setInstance() {
        if (singleton == null) {
            singleton = new MainConfig();
        }
        return MainConfig.get();
    }

    public static MainConfig setInstance(MainConfig conf) {
        if (singleton == null) {
            singleton = conf;
        }
        return MainConfig.get();
    }

    protected MainConfig() {
    }

    public boolean isIgnored(String type) {
        String typeName = type.replace('/', '.');
        for (String prefix : this.DO_INSTRUMENT_PREFIXES) {
            if (!typeName.startsWith(prefix)) continue;
            return false;
        }
        for (String prefix : this.DO_NOT_INSTRUMENT_PREFIXES) {
            if (!typeName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

