/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.executionmode;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.continuous.ContinuousTestGeneration;
import org.evosuite.continuous.CtgConfiguration;
import org.evosuite.shaded.org.apache.commons.cli.CommandLine;
import org.evosuite.shaded.org.apache.commons.cli.Option;
import org.evosuite.shaded.org.apache.commons.cli.Options;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.SpawnProcessKeepAliveChecker;

public class Continuous {
    public static final String NAME = "continuous";

    public static Option getOption() {
        String description = "Run Continuous Test Generation (CTG).";
        description = description + " Valid values are: " + Arrays.toString((Object[])Command.values());
        return new Option(NAME, true, description);
    }

    public static Object execute(Options options, List<String> javaOpts, CommandLine line) {
        File file;
        String opt = line.getOptionValue(NAME);
        if (opt == null) {
            LoggingUtils.getEvoLogger().error("Missing option for -continuous. Use any of " + Arrays.toString((Object[])Command.values()));
            return null;
        }
        Command command = null;
        try {
            command = Command.valueOf(opt.toUpperCase());
        }
        catch (Exception e) {
            LoggingUtils.getEvoLogger().error("Invalid option: " + opt + ". Use any of " + Arrays.toString((Object[])Command.values()));
            return null;
        }
        String target = null;
        if (line.hasOption("target") && command.equals((Object)Command.EXECUTE)) {
            target = line.getOptionValue("target");
        }
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        for (String classPathElement : cp.split(File.pathSeparator)) {
            try {
                ClassPathHacker.addFile(classPathElement);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String prefix = "";
        if (line.hasOption("prefix")) {
            prefix = line.getOptionValue("prefix");
        }
        String[] cuts = null;
        if (Properties.CTG_SELECTED_CUTS != null && !Properties.CTG_SELECTED_CUTS.isEmpty()) {
            cuts = Properties.CTG_SELECTED_CUTS.trim().split(",");
        } else if (Properties.CTG_SELECTED_CUTS_FILE_LOCATION != null && !Properties.CTG_SELECTED_CUTS_FILE_LOCATION.isEmpty() && (file = new File(Properties.CTG_SELECTED_CUTS_FILE_LOCATION)).exists()) {
            String cutLine = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                Scanner scanner = new Scanner(in);
                cutLine = scanner.nextLine();
            }
            catch (Exception e) {
                LoggingUtils.getEvoLogger().error("Error while processing " + file.getAbsolutePath() + " : " + e.getMessage());
            }
            if (cutLine != null) {
                cuts = cutLine.trim().split(",");
            }
        }
        ContinuousTestGeneration ctg = new ContinuousTestGeneration(target, cp, prefix, CtgConfiguration.getFromParameters(), cuts, Properties.CTG_EXPORT_FOLDER);
        if (command.equals((Object)Command.EXECUTE)) {
            if (Properties.SPAWN_PROCESS_MANAGER_PORT == null) {
                int port = SpawnProcessKeepAliveChecker.getInstance().startServer();
                Properties.SPAWN_PROCESS_MANAGER_PORT = port;
            }
            String result = ctg.execute();
            LoggingUtils.getEvoLogger().info(result);
        } else if (command.equals((Object)Command.CLEAN)) {
            boolean cleaned = ctg.clean();
            if (cleaned) {
                LoggingUtils.getEvoLogger().info("Cleaned all project data");
            } else {
                LoggingUtils.getEvoLogger().info("Failed to clean project");
            }
        } else {
            String info = ctg.info();
            LoggingUtils.getEvoLogger().info(info);
        }
        return null;
    }

    public static enum Command {
        EXECUTE,
        INFO,
        CLEAN;

    }
}

