/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.executionmode;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.shaded.org.apache.commons.cli.Option;
import org.evosuite.utils.LoggingUtils;

public class ListParameters {
    public static final String NAME = "listParameters";

    public static Option getOption() {
        return new Option(NAME, "list all the parameters that can be set with -D");
    }

    public static Object execute() {
        ArrayList<Row> rows = new ArrayList<Row>();
        Properties.getInstance().resetToDefaults();
        for (Field f : Properties.class.getFields()) {
            String def;
            if (!f.isAnnotationPresent(Properties.Parameter.class)) continue;
            Properties.Parameter p = f.getAnnotation(Properties.Parameter.class);
            String description = p.description();
            Class<?> type = f.getType();
            if (type.isEnum()) {
                description = description + " (Values: " + Arrays.toString(type.getEnumConstants()) + ")";
            }
            try {
                Object obj = f.get(null);
                def = obj == null ? "" : (type.isArray() ? Arrays.toString((Object[])obj) : obj.toString());
            }
            catch (Exception e) {
                def = "";
            }
            rows.add(new Row(p.key(), type.getSimpleName(), description, def));
        }
        Collections.sort(rows);
        String name = "Name";
        String type = "Type";
        String defaultValue = "Default";
        String description = "Description";
        String space = "   ";
        int maxName = Math.max(name.length(), ListParameters.getMaxNameLength(rows));
        int maxType = Math.max(type.length(), ListParameters.getMaxTypeLength(rows));
        int maxDefault = Math.max(defaultValue.length(), ListParameters.getMaxDefaultLength(rows));
        LoggingUtils.getEvoLogger().info(name + ListParameters.getGap(name, maxName) + space + type + ListParameters.getGap(type, maxType) + space + defaultValue + ListParameters.getGap(defaultValue, maxDefault) + space + description);
        for (Row row : rows) {
            LoggingUtils.getEvoLogger().info(row.name + ListParameters.getGap(row.name, maxName) + space + row.type + ListParameters.getGap(row.type, maxType) + space + row.defaultValue + ListParameters.getGap(row.defaultValue, maxDefault) + space + row.description);
        }
        return null;
    }

    private static String getGap(String s, int max) {
        String gap = "";
        for (int i = 0; i < max - s.length(); ++i) {
            gap = gap + " ";
        }
        return gap;
    }

    private static int getMaxNameLength(List<Row> rows) {
        int max = 0;
        for (Row row : rows) {
            if (row.name.length() <= max) continue;
            max = row.name.length();
        }
        return max;
    }

    private static int getMaxDefaultLength(List<Row> rows) {
        int max = 0;
        for (Row row : rows) {
            if (row.defaultValue.length() <= max) continue;
            max = row.defaultValue.length();
        }
        return max;
    }

    private static int getMaxTypeLength(List<Row> rows) {
        int max = 0;
        for (Row row : rows) {
            if (row.type.length() <= max) continue;
            max = row.type.length();
        }
        return max;
    }

    private static class Row
    implements Comparable<Row> {
        public final String name;
        public final String type;
        public final String description;
        public final String defaultValue;

        public Row(String name, String type, String description, String defaultValue) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        @Override
        public int compareTo(Row other) {
            return this.name.compareTo(other.name);
        }
    }
}

