/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.io.Serializable;
import org.evosuite.ga.Chromosome;

public abstract class ReplacementFunction<T extends Chromosome<T>>
implements Serializable {
    private static final long serialVersionUID = 8507488475265387482L;
    protected boolean maximize = false;

    public ReplacementFunction(boolean maximize) {
        this.maximize = maximize;
    }

    protected boolean isBetter(T chromosome1, T chromosome2) {
        if (this.maximize) {
            return ((Chromosome)chromosome1).compareTo(chromosome2) > 0;
        }
        return ((Chromosome)chromosome1).compareTo(chromosome2) < 0;
    }

    protected boolean isBetterOrEqual(T chromosome1, T chromosome2) {
        if (this.maximize) {
            return chromosome1.compareTo((Chromosome)((Chromosome)chromosome2.self())) >= 0;
        }
        return chromosome1.compareTo((Chromosome)((Chromosome)chromosome2.self())) <= 0;
    }

    protected T getBest(T chromosome1, T chromosome2) {
        if (this.isBetter(chromosome1, chromosome2)) {
            return chromosome1;
        }
        return chromosome2;
    }

    public boolean keepOffspring(T parent1, T parent2, T offspring1, T offspring2) {
        if (this.maximize) {
            return this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2) >= 0;
        }
        return this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2) <= 0;
    }

    protected int compareBestOffspringToBestParent(T parent1, T parent2, T offspring1, T offspring2) {
        T bestOffspring = this.getBest(offspring1, offspring2);
        T bestParent = this.getBest(parent1, parent2);
        return ((Chromosome)bestOffspring).compareTo(bestParent);
    }

    @Deprecated
    public boolean keepOffspring(T parent, T offspring) {
        return this.isBetterOrEqual(offspring, parent);
    }
}

