/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.archive;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageArchive
extends Archive {
    private static final long serialVersionUID = -4046845573050661961L;
    private static final Logger logger = LoggerFactory.getLogger(CoverageArchive.class);
    private final Map<TestFitnessFunction, TestChromosome> covered = new LinkedHashMap<TestFitnessFunction, TestChromosome>();
    private final Set<TestFitnessFunction> uncovered = new LinkedHashSet<TestFitnessFunction>();
    public static final CoverageArchive instance = new CoverageArchive();

    @Override
    public void addTarget(TestFitnessFunction target) {
        super.addTarget(target);
        if (!this.uncovered.contains(target)) {
            logger.debug("Registering new target '" + target + "'");
            this.uncovered.add(target);
        }
        this.registerNonCoveredTargetOfAMethod(target);
    }

    @Override
    public void updateArchive(TestFitnessFunction target, TestChromosome solution, double fitnessValue) {
        super.updateArchive(target, solution, fitnessValue);
        assert (this.covered.containsKey(target) || this.uncovered.contains(target)) : "Unknown goal: " + target;
        if (fitnessValue > 0.0) {
            return;
        }
        boolean isNewCoveredTarget = false;
        boolean isNewSolutionBetterThanCurrent = false;
        TestChromosome currentSolution = this.covered.get(target);
        if (currentSolution == null) {
            logger.debug("Solution for non-covered target '" + target + "'");
            isNewCoveredTarget = true;
        } else {
            isNewSolutionBetterThanCurrent = this.isBetterThanCurrent(currentSolution, solution);
        }
        if (isNewCoveredTarget || isNewSolutionBetterThanCurrent) {
            this.addToArchive(target, solution);
        }
    }

    private void addToArchive(TestFitnessFunction target, TestChromosome solution) {
        this.uncovered.remove(target);
        this.covered.put(target, solution);
        this.removeNonCoveredTargetOfAMethod(target);
        this.hasBeenUpdated = true;
        ExecutionResult result = solution.getLastExecutionResult();
        if (result != null && (result.hasTimeout() || result.hasTestException())) {
            AtMostOnceLogger.warn(logger, "A solution with a timeout/exception result has been added to the archive. The covered goal was " + target.toString());
        }
    }

    @Override
    public boolean isArchiveEmpty() {
        return this.covered.isEmpty();
    }

    @Override
    public int getNumberOfTargets() {
        return this.covered.keySet().size() + this.uncovered.size();
    }

    @Override
    public int getNumberOfCoveredTargets() {
        return this.covered.size();
    }

    @Override
    public int getNumberOfCoveredTargets(Class<?> targetClass) {
        return (int)this.covered.keySet().stream().filter(target -> target.getClass() == targetClass).count();
    }

    @Override
    public Set<TestFitnessFunction> getCoveredTargets() {
        return this.covered.keySet();
    }

    @Override
    public int getNumberOfUncoveredTargets() {
        return this.uncovered.size();
    }

    @Override
    public int getNumberOfUncoveredTargets(Class<?> targetClass) {
        return (int)this.uncovered.stream().filter(target -> target.getClass() == targetClass).count();
    }

    @Override
    public Set<TestFitnessFunction> getUncoveredTargets() {
        return this.uncovered;
    }

    private Set<TestFitnessFunction> getTargets() {
        LinkedHashSet<TestFitnessFunction> targets = new LinkedHashSet<TestFitnessFunction>();
        targets.addAll(this.getCoveredTargets());
        targets.addAll(this.getUncoveredTargets());
        return targets;
    }

    @Override
    public boolean hasTarget(TestFitnessFunction target) {
        assert (target != null);
        return this.covered.containsKey(target) || this.uncovered.contains(target);
    }

    @Override
    public int getNumberOfSolutions() {
        return this.covered.size();
    }

    @Override
    public Set<TestChromosome> getSolutions() {
        return new LinkedHashSet<TestChromosome>(this.covered.values());
    }

    @Override
    public TestChromosome getSolution() {
        return this.getRandomSolution();
    }

    @Override
    public TestChromosome getSolution(TestFitnessFunction target) {
        assert (target != null);
        assert (this.covered.containsKey(target));
        return this.covered.get(target);
    }

    @Override
    public boolean hasSolution(TestFitnessFunction target) {
        assert (target != null);
        return this.covered.containsKey(target);
    }

    @Override
    public TestChromosome getRandomSolution() {
        TestChromosome randomChoice = Randomness.choice(this.getSolutions());
        if (randomChoice == null) {
            return null;
        }
        return randomChoice.clone();
    }

    @Override
    protected TestSuiteChromosome createMergedSolution(TestSuiteChromosome solution) {
        Properties.TEST_ARCHIVE = false;
        TestSuiteChromosome mergedSolution = solution.clone();
        mergedSolution.getTestChromosomes().removeIf(t -> t.isChanged() || t.getLastExecutionResult() != null && (t.getLastExecutionResult().hasTimeout() || t.getLastExecutionResult().hasTestException()));
        LinkedHashSet<TestChromosome> solutionsSampledFromArchive = new LinkedHashSet<TestChromosome>();
        for (TestFitnessFunction testFitnessFunction : this.getTargets()) {
            TestChromosome chromosome;
            boolean isGoalCovered = false;
            for (TestChromosome test : mergedSolution.getTestChromosomes()) {
                if (!test.getTestCase().isGoalCovered(testFitnessFunction)) continue;
                isGoalCovered = true;
                break;
            }
            if (isGoalCovered || (chromosome = this.covered.get(testFitnessFunction)) == null || solutionsSampledFromArchive.contains(chromosome)) continue;
            solutionsSampledFromArchive.add(chromosome);
            mergedSolution.addTest(chromosome);
        }
        for (FitnessFunction fitnessFunction : solution.getFitnessValues().keySet()) {
            fitnessFunction.getFitness(mergedSolution);
        }
        Properties.TEST_ARCHIVE = true;
        return mergedSolution;
    }

    @Override
    public void shrinkSolutions(int size) {
    }

    @Override
    public String toString() {
        return "NumTargets: " + this.getNumberOfTargets() + ", NumCoveredTargets: " + this.getNumberOfCoveredTargets() + ", NumSolutions: " + this.getNumberOfSolutions();
    }

    @Override
    public void reset() {
        super.reset();
        this.covered.clear();
        this.uncovered.clear();
    }
}

