/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.archive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.shaded.org.apache.commons.lang3.tuple.ImmutablePair;
import org.evosuite.shaded.org.apache.commons.lang3.tuple.Pair;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MIOArchive
extends Archive {
    private static final long serialVersionUID = -6100903230303784634L;
    private static final Logger logger = LoggerFactory.getLogger(MIOArchive.class);
    protected final Map<TestFitnessFunction, Population> archive = new LinkedHashMap<TestFitnessFunction, Population>();
    public static final MIOArchive instance = new MIOArchive();

    @Override
    public void addTarget(TestFitnessFunction target) {
        super.addTarget(target);
        if (!this.archive.containsKey(target)) {
            logger.debug("Registering new target '" + target + "'");
            this.archive.put(target, new Population(Properties.NUMBER_OF_TESTS_PER_TARGET));
        }
        this.registerNonCoveredTargetOfAMethod(target);
    }

    @Override
    public void updateArchive(TestFitnessFunction target, TestChromosome solution, double fitnessValue) {
        boolean isNewCoveredTarget;
        super.updateArchive(target, solution, fitnessValue);
        assert (this.archive.containsKey(target));
        ExecutionResult executionResult = solution.getLastExecutionResult();
        if (!executionResult.noThrownExceptions()) {
            solution.getTestCase().chop(executionResult.getFirstPositionOfThrownException() + 1);
        }
        if (isNewCoveredTarget = this.archive.get(target).addSolution(1.0 - FitnessFunction.normalize(fitnessValue), solution)) {
            this.removeNonCoveredTargetOfAMethod(target);
            this.hasBeenUpdated = true;
        }
    }

    @Override
    public boolean isArchiveEmpty() {
        return this.getNumberOfSolutions() == 0;
    }

    @Override
    public int getNumberOfTargets() {
        return this.archive.keySet().size();
    }

    @Override
    public int getNumberOfCoveredTargets() {
        return this.getCoveredTargets().size();
    }

    @Override
    public int getNumberOfCoveredTargets(Class<?> targetClass) {
        return (int)this.getCoveredTargets().stream().filter(target -> target.getClass() == targetClass).count();
    }

    @Override
    public Set<TestFitnessFunction> getCoveredTargets() {
        return this.archive.keySet().stream().filter(target -> this.archive.get(target).isCovered()).collect(Collectors.toSet());
    }

    @Override
    public int getNumberOfUncoveredTargets() {
        return this.getUncoveredTargets().size();
    }

    @Override
    public int getNumberOfUncoveredTargets(Class<?> targetClass) {
        return (int)this.getUncoveredTargets().stream().filter(target -> target.getClass() == targetClass).count();
    }

    @Override
    public Set<TestFitnessFunction> getUncoveredTargets() {
        return this.archive.keySet().stream().filter(target -> !this.archive.get(target).isCovered()).collect(Collectors.toSet());
    }

    @Override
    public boolean hasTarget(TestFitnessFunction target) {
        assert (target != null);
        return this.archive.containsKey(target);
    }

    @Override
    public int getNumberOfSolutions() {
        return this.getSolutions().size();
    }

    @Override
    public Set<TestChromosome> getSolutions() {
        return this.archive.values().stream().map(rec$ -> ((Population)rec$).getBestSolutionIfAny()).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public TestChromosome getSolution() {
        List targetsWithSolutions = this.archive.keySet().stream().filter(target -> this.archive.get(target).numSolutions() > 0).collect(Collectors.toList());
        if (targetsWithSolutions.isEmpty()) {
            return null;
        }
        List potentialTargets = targetsWithSolutions.stream().filter(target -> !this.archive.get(target).isCovered()).collect(Collectors.toList());
        if (potentialTargets.isEmpty()) {
            potentialTargets = targetsWithSolutions.stream().filter(target -> this.archive.get(target).isCovered()).collect(Collectors.toList());
        }
        assert (!potentialTargets.isEmpty());
        potentialTargets.sort(Comparator.comparingInt(f -> this.archive.get(f).counter()));
        TestChromosome randomSolution = this.archive.get(potentialTargets.get(0)).sampleSolution();
        return randomSolution == null ? null : randomSolution.clone();
    }

    @Override
    public TestChromosome getSolution(TestFitnessFunction target) {
        assert (target != null);
        assert (this.archive.containsKey(target));
        return this.archive.get(target).getBestSolutionIfAny();
    }

    @Override
    public boolean hasSolution(TestFitnessFunction target) {
        assert (target != null);
        assert (this.archive.containsKey(target));
        return this.archive.get(target).isCovered();
    }

    @Override
    public TestChromosome getRandomSolution() {
        return Randomness.choice(this.getSolutions());
    }

    @Override
    protected TestSuiteChromosome createMergedSolution(TestSuiteChromosome solution) {
        Properties.TEST_ARCHIVE = false;
        TestSuiteChromosome mergedSolution = solution.clone();
        LinkedHashSet<TestChromosome> solutionsSampledFromArchive = new LinkedHashSet<TestChromosome>();
        for (TestFitnessFunction testFitnessFunction : this.archive.keySet()) {
            Population population;
            TestChromosome t;
            if (testFitnessFunction.isCoveredBy(mergedSolution) || (t = (population = this.archive.get(testFitnessFunction)).getBestSolutionIfAny()) == null || solutionsSampledFromArchive.contains(t)) continue;
            solutionsSampledFromArchive.add(t);
            TestChromosome tClone = t.clone();
            mergedSolution.addTest(tClone);
        }
        for (FitnessFunction fitnessFunction : solution.getFitnessValues().keySet()) {
            fitnessFunction.getFitness(mergedSolution);
        }
        Properties.TEST_ARCHIVE = true;
        logger.info("Final test suite size from archive: " + mergedSolution);
        return mergedSolution;
    }

    @Override
    public void shrinkSolutions(int newPopulationSize) {
        assert (newPopulationSize > 0);
        for (TestFitnessFunction target : this.archive.keySet()) {
            this.archive.get(target).shrinkPopulation(newPopulationSize);
        }
    }

    @Override
    public String toString() {
        return "NumTargets: " + this.getNumberOfTargets() + ", NumCoveredTargets: " + this.getNumberOfCoveredTargets() + ", NumSolutions: " + this.getNumberOfSolutions();
    }

    @Override
    public void reset() {
        super.reset();
        this.archive.clear();
    }

    private class Population
    implements Serializable {
        private static final long serialVersionUID = 1671692598239736237L;
        private int counter = 0;
        private int capacity;
        private List<Pair<Double, TestChromosome>> solutions = null;

        private Population(int populationSize) {
            this.capacity = populationSize;
            this.solutions = new ArrayList<Pair<Double, TestChromosome>>(populationSize);
        }

        private int counter() {
            return this.counter;
        }

        private boolean isCovered() {
            return this.solutions.size() == 1 && this.capacity == 1 && this.solutions.get(0).getLeft() == 1.0;
        }

        private boolean addSolution(Double h, TestChromosome t) {
            assert (h >= 0.0 && h <= 1.0);
            if (h == 0.0) {
                return false;
            }
            if (h < 1.0 && this.isCovered()) {
                return false;
            }
            ImmutablePair<Double, TestChromosome> candidateSolution = new ImmutablePair<Double, TestChromosome>(h, t);
            boolean added = false;
            if (h == 1.0) {
                if (this.isCovered()) {
                    Pair<Double, TestChromosome> currentSolution = this.solutions.get(0);
                    if (this.isPairBetterThanCurrent(currentSolution, candidateSolution)) {
                        added = true;
                        this.solutions.set(0, candidateSolution);
                    }
                } else {
                    added = true;
                    this.capacity = 1;
                    this.solutions.clear();
                    this.solutions.add(candidateSolution);
                }
            } else if (this.solutions.size() < this.capacity) {
                this.solutions.add(candidateSolution);
                this.sortPairSolutions();
            } else {
                this.sortPairSolutions();
                Pair<Double, TestChromosome> worstSolution = this.solutions.get(this.capacity - 1);
                if (this.isPairBetterThanCurrent(worstSolution, candidateSolution)) {
                    this.solutions.set(this.capacity - 1, candidateSolution);
                }
            }
            assert (this.solutions.size() <= this.capacity);
            if (added) {
                this.counter = 0;
            }
            return added;
        }

        private boolean isPairBetterThanCurrent(Pair<Double, TestChromosome> currentSolution, Pair<Double, TestChromosome> candidateSolution) {
            int cmp = Double.compare(currentSolution.getLeft(), candidateSolution.getLeft());
            if (cmp < 0) {
                return true;
            }
            if (cmp > 0) {
                return false;
            }
            assert (cmp == 0);
            return MIOArchive.this.isBetterThanCurrent(currentSolution.getRight(), candidateSolution.getRight());
        }

        private TestChromosome sampleSolution() {
            if (this.numSolutions() == 0) {
                return null;
            }
            ++this.counter;
            return Randomness.choice(this.solutions).getRight();
        }

        private void sortPairSolutions() {
            this.solutions.sort((solution0, solution1) -> {
                if ((Double)solution0.getLeft() < (Double)solution1.getLeft()) {
                    return 1;
                }
                if ((Double)solution0.getLeft() > (Double)solution1.getLeft()) {
                    return -1;
                }
                return 0;
            });
        }

        private int numSolutions() {
            return this.solutions.size();
        }

        private TestChromosome getBestSolutionIfAny() {
            if (this.numSolutions() == 0 || !this.isCovered()) {
                return null;
            }
            return this.solutions.get(0).getRight();
        }

        private void shrinkPopulation(int newPopulationSize) {
            assert (newPopulationSize > 0);
            if (this.isCovered()) {
                return;
            }
            this.capacity = newPopulationSize;
            if (this.numSolutions() < newPopulationSize) {
                return;
            }
            ArrayList<Pair<Double, TestChromosome>> shrinkSolutions = new ArrayList<Pair<Double, TestChromosome>>(newPopulationSize);
            for (int i = 0; i < newPopulationSize; ++i) {
                shrinkSolutions.add(this.solutions.get(i));
            }
            this.solutions.clear();
            this.solutions.addAll(shrinkSolutions);
        }

        public int hashCode() {
            return 31 * this.counter + this.capacity + this.solutions.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Population p = (Population)obj;
            if (this.counter != p.counter) {
                return false;
            }
            if (this.capacity != p.capacity) {
                return false;
            }
            if (this.solutions.size() != p.solutions.size()) {
                return false;
            }
            return this.solutions.equals(p.solutions);
        }
    }
}

