/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.comparators;

import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;

public class DominanceComparator<T extends Chromosome<T>>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = -2154238776555768364L;
    private Set<FitnessFunction<T>> objectives;

    public DominanceComparator() {
        this.objectives = null;
    }

    public DominanceComparator(Set<? extends FitnessFunction<T>> goals) {
        this.objectives = new LinkedHashSet<FitnessFunction<T>>(goals);
    }

    public DominanceComparator(FitnessFunction<T> goal) {
        this.objectives = new LinkedHashSet<FitnessFunction<T>>();
        this.objectives.add(goal);
    }

    @Override
    public int compare(T c1, T c2) {
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        boolean dominate1 = false;
        boolean dominate2 = false;
        if (this.objectives == null) {
            this.objectives = new LinkedHashSet(((Chromosome)c1).getFitnessValues().keySet());
        }
        for (FitnessFunction<T> ff : this.objectives) {
            int flag = Double.compare(((Chromosome)c1).getFitness(ff), ((Chromosome)c2).getFitness(ff));
            if (flag < 0) {
                dominate1 = true;
                if (!dominate2) continue;
                return 0;
            }
            if (flag <= 0) continue;
            dominate2 = true;
            if (!dominate1) continue;
            return 0;
        }
        if (dominate1 == dominate2) {
            return 0;
        }
        if (dominate1) {
            return -1;
        }
        return 1;
    }
}

