/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.comparators;

import java.io.Serializable;
import java.util.Comparator;
import org.evosuite.ga.Chromosome;

public class RankAndCrowdingDistanceComparator<T extends Chromosome<T>>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = -1663917547588039444L;
    private boolean isToMaximize;

    public RankAndCrowdingDistanceComparator() {
        this.isToMaximize = false;
    }

    public RankAndCrowdingDistanceComparator(boolean maximize) {
        this.isToMaximize = maximize;
    }

    public RankAndCrowdingDistanceComparator(RankAndCrowdingDistanceComparator<?> other) {
        this.isToMaximize = other.isToMaximize;
    }

    @Override
    public int compare(T c1, T c2) {
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        if (((Chromosome)c1).getRank() == ((Chromosome)c2).getRank() && ((Chromosome)c1).getDistance() == ((Chromosome)c2).getDistance()) {
            return 0;
        }
        if (this.isToMaximize) {
            if (((Chromosome)c1).getRank() < ((Chromosome)c2).getRank()) {
                return 1;
            }
            if (((Chromosome)c1).getRank() > ((Chromosome)c2).getRank()) {
                return -1;
            }
            if (((Chromosome)c1).getRank() == ((Chromosome)c2).getRank()) {
                return ((Chromosome)c1).getDistance() > ((Chromosome)c2).getDistance() ? -1 : 1;
            }
        } else {
            if (((Chromosome)c1).getRank() < ((Chromosome)c2).getRank()) {
                return -1;
            }
            if (((Chromosome)c1).getRank() > ((Chromosome)c2).getRank()) {
                return 1;
            }
            if (((Chromosome)c1).getRank() == ((Chromosome)c2).getRank()) {
                return ((Chromosome)c1).getDistance() > ((Chromosome)c2).getDistance() ? -1 : 1;
            }
        }
        return 0;
    }

    public void setMaximize(boolean max) {
        this.isToMaximize = max;
    }
}

