/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.comparators;

import java.io.Serializable;
import java.util.Comparator;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;

public class SortByFitness<T extends Chromosome<T>>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 4982933698286500461L;
    private final FitnessFunction<T> ff;
    private final boolean order;

    public SortByFitness(FitnessFunction<T> ff, boolean desc) {
        this.ff = ff;
        this.order = desc;
    }

    @Override
    public int compare(T c1, T c2) {
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        double objetive1 = ((Chromosome)c1).getFitness(this.ff);
        double objetive2 = ((Chromosome)c2).getFitness(this.ff);
        return this.order ? Double.compare(objetive2, objetive1) : Double.compare(objetive1, objetive2);
    }
}

