/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.localsearch;

import java.io.Serializable;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSearchBudget<T extends Chromosome<T>>
implements SearchListener<T>,
Serializable {
    private static final long serialVersionUID = 9152147170303160131L;
    private static final Logger logger = LoggerFactory.getLogger(LocalSearchBudget.class);
    private static LocalSearchBudget<?> instance = null;
    protected int fitnessEvaluations = 0;
    protected int tests = 0;
    protected long executedStart = 0L;
    protected int suites = 0;
    protected long startTime = 0L;
    protected long endTime = 0L;
    protected GeneticAlgorithm<?> ga = null;

    private LocalSearchBudget() {
    }

    public static <T extends Chromosome<T>> LocalSearchBudget<T> getInstance() {
        if (instance == null) {
            instance = new LocalSearchBudget<T>();
        }
        return instance;
    }

    public boolean isFinished() {
        if (this.ga != null && this.ga.isFinished()) {
            return true;
        }
        boolean isFinished = false;
        switch (Properties.LOCAL_SEARCH_BUDGET_TYPE) {
            case FITNESS_EVALUATIONS: {
                isFinished = (long)this.fitnessEvaluations >= Properties.LOCAL_SEARCH_BUDGET;
                break;
            }
            case SUITES: {
                isFinished = (long)this.suites >= Properties.LOCAL_SEARCH_BUDGET;
                break;
            }
            case STATEMENTS: {
                isFinished = MaxStatementsStoppingCondition.getNumExecutedStatements() > this.executedStart + Properties.LOCAL_SEARCH_BUDGET;
                break;
            }
            case TESTS: {
                isFinished = (long)this.tests >= Properties.LOCAL_SEARCH_BUDGET;
                break;
            }
            case TIME: {
                isFinished = System.currentTimeMillis() > this.endTime;
                break;
            }
            default: {
                throw new RuntimeException("Unknown budget type: " + (Object)((Object)Properties.LOCAL_SEARCH_BUDGET_TYPE));
            }
        }
        if (isFinished) {
            logger.info("Local search budget used up; type: " + (Object)((Object)Properties.LOCAL_SEARCH_BUDGET_TYPE));
        }
        return isFinished;
    }

    public void countFitnessEvaluation() {
        ++this.fitnessEvaluations;
    }

    public void countLocalSearchOnTest() {
        ++this.tests;
    }

    public void countLocalSearchOnTestSuite() {
        ++this.suites;
    }

    public void localSearchStarted() {
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + Properties.LOCAL_SEARCH_BUDGET * 1000L;
        this.tests = 0;
        this.suites = 0;
        this.fitnessEvaluations = 0;
        this.executedStart = MaxStatementsStoppingCondition.getNumExecutedStatements();
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
        this.ga = algorithm;
        this.tests = 0;
        this.suites = 0;
        this.fitnessEvaluations = 0;
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
        this.tests = 0;
        this.suites = 0;
        this.fitnessEvaluations = 0;
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
        this.ga = null;
    }

    @Override
    public void fitnessEvaluation(T individual) {
    }

    @Override
    public void modification(T individual) {
    }
}

