/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.Objects;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class AdapteeListener
implements SearchListener<TestChromosome> {
    private final GeneticAlgorithm<TestSuiteChromosome> adapter;
    private final boolean notifyEvaluation;
    private final boolean notifyMutation;

    public AdapteeListener(GeneticAlgorithm<TestSuiteChromosome> adapter, boolean notifyEvaluation, boolean notifyMutation) {
        this.adapter = Objects.requireNonNull(adapter);
        this.notifyEvaluation = notifyEvaluation;
        this.notifyMutation = notifyMutation;
    }

    public AdapteeListener(GeneticAlgorithm<TestSuiteChromosome> adapter) {
        this(adapter, false, false);
    }

    @Override
    public void searchStarted(GeneticAlgorithm<TestChromosome> algorithm) {
        this.adapter.notifySearchStarted();
    }

    @Override
    public void iteration(GeneticAlgorithm<TestChromosome> algorithm) {
        this.adapter.notifyIteration();
    }

    @Override
    public void searchFinished(GeneticAlgorithm<TestChromosome> algorithm) {
        this.adapter.notifySearchFinished();
    }

    @Override
    public void fitnessEvaluation(TestChromosome individual) {
        if (this.notifyEvaluation) {
            this.adapter.notifyEvaluation(individual.toSuite());
        }
    }

    @Override
    public void modification(TestChromosome individual) {
        if (this.notifyMutation) {
            this.adapter.notifyMutation(individual.toSuite());
        }
    }
}

