/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.ProgressMonitor;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.SortByFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.metaheuristics.mosa.structural.BranchesManager;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.BudgetConsumptionMonitor;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIPS
extends GeneticAlgorithm<TestChromosome> {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(LIPS.class);
    protected Map<TestFitnessFunction, TestChromosome> archive = new HashMap<TestFitnessFunction, TestChromosome>();
    protected Set<FitnessFunction<TestChromosome>> uncoveredBranches = new HashSet<FitnessFunction<TestChromosome>>();
    protected TestSuiteFitnessFunction suiteFitness;
    protected LinkedList<TestFitnessFunction> worklist = new LinkedList();
    protected LinkedList<TestFitnessFunction> alreadyAttemptedBranches = new LinkedList();
    protected TestFitnessFunction currentTarget;
    protected BranchesManager CFG;
    protected long startSearch4Branch = 0L;
    protected long startGlobalSearch = 0L;
    protected long budget4branch;
    protected BudgetConsumptionMonitor budgetMonitor;

    public LIPS(ChromosomeFactory<TestChromosome> factory) {
        super(factory);
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.BRANCH)) {
            this.suiteFitness = new BranchCoverageSuiteFitness();
        }
        this.startGlobalSearch = System.currentTimeMillis();
        this.budgetMonitor = new BudgetConsumptionMonitor();
    }

    @Override
    protected void evolve() {
        ArrayList<TestChromosome> newGeneration = new ArrayList<TestChromosome>();
        this.population.sort(new SortByFitness<TestChromosome>(this.currentTarget, false));
        newGeneration.add(((TestChromosome)this.population.get(0)).clone());
        newGeneration.add(((TestChromosome)this.population.get(1)).clone());
        while (newGeneration.size() < Properties.POPULATION) {
            TestChromosome parent1 = (TestChromosome)this.selectionFunction.select(this.population);
            TestChromosome parent2 = (TestChromosome)this.selectionFunction.select(this.population);
            TestChromosome offspring1 = parent1.clone();
            TestChromosome offspring2 = parent2.clone();
            try {
                if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
                this.notifyMutation(offspring1);
                offspring1.mutate();
                newGeneration.add(offspring1);
                this.notifyMutation(offspring2);
                offspring2.mutate();
                newGeneration.add(offspring2);
                if (offspring1.isChanged()) {
                    offspring1.updateAge(this.currentIteration);
                }
                if (!offspring2.isChanged()) continue;
                offspring2.updateAge(this.currentIteration);
            }
            catch (ConstructionFailedException e) {
                logger.info("CrossOver/Mutation failed.");
            }
        }
        this.population.clear();
        this.population = newGeneration;
        this.calculateFitness();
    }

    @Override
    public void initializePopulation() {
        logger.info("executing initializePopulation function");
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION - 1);
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        logger.info("executing generateSolution function");
        this.CFG = new BranchesManager(this.fitnessFunctions.stream().map(ff -> (TestFitnessFunction)ff).collect(Collectors.toList()));
        this.searchInitialization();
        this.initializePopulation();
        this.calculateFitness();
        while (!this.isFinished() && this.uncoveredBranches.size() > 0) {
            this.evolve();
            if (this.archive.containsKey(this.currentTarget)) {
                if (this.worklist.size() > 0) {
                    this.currentTarget = this.worklist.removeLast();
                }
                this.startSearch4Branch = System.currentTimeMillis();
            } else if (Math.abs(System.currentTimeMillis() - this.startSearch4Branch) >= this.budget4branch) {
                this.alreadyAttemptedBranches.add(this.currentTarget);
                if (this.worklist.isEmpty()) {
                    this.worklist.addAll(this.alreadyAttemptedBranches);
                    this.alreadyAttemptedBranches.clear();
                }
                this.currentTarget = this.worklist.removeLast();
                this.startSearch4Branch = System.currentTimeMillis();
                logger.debug("SWITCHING TARGET");
            }
            this.updateBudget4Branch();
            ++this.currentIteration;
            this.notifyIteration();
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Time2MaxCoverage, this.budgetMonitor.getTime2MaxCoverage());
        this.notifySearchFinished();
    }

    @Override
    protected void calculateFitness() {
        for (TestChromosome test : this.population) {
            test.setChanged(true);
            this.runTest(test);
            double value = this.currentTarget.getFitness(test);
            if (value == 0.0) {
                this.updateArchive(test, this.currentTarget);
                this.updateWorkList(test);
            }
            this.computeCollateralCoverage(test);
            this.budgetMonitor.checkMaxCoverage(this.archive.keySet().size());
        }
    }

    protected void searchInitialization() {
        logger.info("generating firts test t0");
        this.notifySearchStarted();
        this.uncoveredBranches.addAll(this.fitnessFunctions);
        this.worklist.addAll(this.CFG.getGraph().getRootBranches());
        TestChromosome t0 = (TestChromosome)this.chromosomeFactory.getChromosome();
        this.runTest(t0);
        this.population.add(t0);
        this.updateWorkList(t0);
        this.currentTarget = this.worklist.removeLast();
    }

    protected void runTest(TestChromosome c) {
        if (!c.isChanged()) {
            return;
        }
        TestCase test = c.getTestCase();
        ExecutionResult result = TestCaseExecutor.runTest(test);
        c.setLastExecutionResult(result);
        c.setChanged(false);
        this.notifyEvaluation(c);
    }

    protected void computeCollateralCoverage(TestChromosome c) {
        for (TestFitnessFunction branch : this.worklist) {
            double value = branch.getFitness(c);
            if (value != 0.0) continue;
            this.updateArchive(c, branch);
        }
        this.worklist.removeAll(this.archive.keySet());
        this.alreadyAttemptedBranches.removeAll(this.archive.keySet());
    }

    protected void updateWorkList(TestChromosome c) {
        HashSet<TestFitnessFunction> coveredBranches = new HashSet<TestFitnessFunction>();
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            double value = fitnessFunction.getFitness(c);
            if (value != 0.0) continue;
            coveredBranches.add((TestFitnessFunction)fitnessFunction);
        }
        for (TestFitnessFunction testFitnessFunction : coveredBranches) {
            this.updateArchive(c, testFitnessFunction);
            for (TestFitnessFunction dependent : this.CFG.getGraph().getStructuralChildren(testFitnessFunction)) {
                if (!this.uncoveredBranches.contains(dependent) || this.worklist.contains(dependent)) continue;
                this.worklist.addFirst(dependent);
            }
        }
    }

    private void updateArchive(TestChromosome solution, TestFitnessFunction covered) {
        solution.getTestCase().getCoveredGoals().add(covered);
        if (!this.archive.containsKey(covered)) {
            this.archive.put(covered, solution);
            this.uncoveredBranches.remove(covered);
        }
    }

    @Override
    protected void notifyEvaluation(TestChromosome chromosome) {
        for (SearchListener listener : this.listeners) {
            if (listener instanceof ProgressMonitor) continue;
            listener.fitnessEvaluation(chromosome);
        }
    }

    @Override
    public TestChromosome getBestIndividual() {
        throw new UnsupportedOperationException("LIPS does not provide such functionality");
    }

    protected List<TestChromosome> getArchive() {
        return new ArrayList<TestChromosome>(new HashSet<TestChromosome>(this.archive.values()));
    }

    protected List<TestChromosome> getFinalTestSuite() {
        if (this.numberOfCoveredTargets() == 0.0) {
            return this.getArchive();
        }
        if (this.archive.size() == 0 && this.population.size() > 0) {
            ArrayList<TestChromosome> list = new ArrayList<TestChromosome>();
            list.add((TestChromosome)this.population.get(this.population.size() - 1));
            return list;
        }
        return this.getArchive();
    }

    protected double numberOfCoveredTargets() {
        return this.archive.keySet().size();
    }

    protected void updateBudget4Branch() {
        long budgetLeft = Properties.SEARCH_BUDGET * 1000L - (System.currentTimeMillis() - this.startGlobalSearch);
        long n_targets = this.fitnessFunctions.size() - this.archive.size() - this.alreadyAttemptedBranches.size();
        if (n_targets > 0L) {
            this.budget4branch = budgetLeft / n_targets;
        }
    }
}

