/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.RankAndCrowdingDistanceComparator;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.operators.ranking.CrowdingDistance;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSGAII<T extends Chromosome<T>>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(NSGAII.class);
    private final CrowdingDistance<T> crowdingDistance = new CrowdingDistance();

    public NSGAII(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        ArrayList<Object> offspringPopulation = new ArrayList<Object>(this.population.size());
        for (int i = 0; i < this.population.size() / 2; ++i) {
            Object parent1 = this.selectionFunction.select(this.population);
            Object parent2 = this.selectionFunction.select(this.population);
            Object offspring1 = ((Chromosome)parent1).clone();
            Object offspring2 = ((Chromosome)parent2).clone();
            try {
                if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
            }
            catch (Exception e) {
                logger.info("CrossOver failed");
            }
            if (Randomness.nextDouble() <= Properties.MUTATION_RATE) {
                this.notifyMutation(offspring1);
                ((Chromosome)offspring1).mutate();
                this.notifyMutation(offspring2);
                ((Chromosome)offspring2).mutate();
            }
            for (FitnessFunction<Object> fitnessFunction : this.getFitnessFunctions()) {
                fitnessFunction.getFitness(offspring1);
                this.notifyEvaluation(offspring1);
                fitnessFunction.getFitness(offspring2);
                this.notifyEvaluation(offspring2);
            }
            offspringPopulation.add(offspring1);
            offspringPopulation.add(offspring2);
        }
        List union = this.union(this.population, offspringPopulation);
        this.rankingFunction.computeRankingAssignment(union, new LinkedHashSet(this.getFitnessFunctions()));
        int remain = this.population.size();
        int index = 0;
        List front = null;
        this.population.clear();
        front = this.rankingFunction.getSubfront(index);
        while (remain > 0 && remain >= front.size()) {
            this.crowdingDistance.crowdingDistanceAssignment(front, this.getFitnessFunctions());
            this.population.addAll(front);
            ++index;
            if ((remain -= front.size()) <= 0) continue;
            front = this.rankingFunction.getSubfront(index);
        }
        if (remain > 0) {
            this.crowdingDistance.crowdingDistanceAssignment(front, this.getFitnessFunctions());
            front.sort(new RankAndCrowdingDistanceComparator(true));
            for (int k = 0; k < remain; ++k) {
                this.population.add(front.get(k));
            }
            remain = 0;
        }
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        logger.info("executing initializePopulation function");
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        logger.info("executing generateSolution function");
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        while (!this.isFinished()) {
            this.evolve();
            this.notifyIteration();
            this.writeIndividuals(this.population);
        }
        this.notifySearchFinished();
    }

    protected List<T> union(List<T> population, List<T> offspringPopulation) {
        int newSize = population.size() + offspringPopulation.size();
        if (newSize < Properties.POPULATION) {
            newSize = Properties.POPULATION;
        }
        ArrayList<T> union = new ArrayList<T>(newSize);
        union.addAll(population);
        for (int i = population.size(); i < population.size() + offspringPopulation.size(); ++i) {
            union.add(offspringPopulation.get(i - population.size()));
        }
        return union;
    }
}

