/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.shaded.org.apache.commons.lang3.tuple.ImmutablePair;
import org.evosuite.shaded.org.apache.commons.lang3.tuple.Pair;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardChemicalReaction<T extends Chromosome<T>>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 2723118789259809773L;
    private static final Logger logger = LoggerFactory.getLogger(StandardChemicalReaction.class);
    private double buffer = 0.0;
    private double initialEnergy = 0.0;
    private List<T> elite = new ArrayList<T>(Properties.ELITE);

    public StandardChemicalReaction(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        if (Randomness.nextDouble() > Properties.MOLECULAR_COLLISION_RATE || this.population.size() == 1) {
            logger.debug("an uni-molecular collision has occurred");
            int moleculeIndex = Randomness.nextInt(this.population.size());
            assert (moleculeIndex >= 0 && moleculeIndex < this.population.size());
            Chromosome molecule = (Chromosome)this.population.get(moleculeIndex);
            assert (molecule != null);
            if (this.decompositionCheck(molecule)) {
                logger.debug("a decomposition has occurred");
                List<Chromosome> offsprings = this.decomposition(molecule);
                if (offsprings != null) {
                    this.population.remove(moleculeIndex);
                    this.population.addAll(offsprings);
                }
            } else {
                logger.debug("an on-wall ineffective collision has occurred");
                Chromosome newMolecule = this.onwallIneffectiveCollision(molecule);
                if (newMolecule != null) {
                    this.population.set(moleculeIndex, newMolecule);
                }
            }
        } else {
            logger.debug("an inter-molecular collision has occurred");
            int molecule1Index = Randomness.nextInt(this.population.size());
            assert (molecule1Index >= 0 && molecule1Index < this.population.size());
            int molecule2Index = Randomness.nextInt(this.population.size());
            while (molecule2Index == molecule1Index) {
                molecule2Index = Randomness.nextInt(this.population.size());
            }
            assert (molecule2Index >= 0 && molecule2Index < this.population.size());
            assert (molecule1Index != molecule2Index);
            Chromosome molecule1 = (Chromosome)this.population.get(molecule1Index);
            Chromosome molecule2 = (Chromosome)this.population.get(molecule2Index);
            if (this.synthesisCheck(molecule1) && this.synthesisCheck(molecule2)) {
                logger.debug("a synthesis has occurred");
                Chromosome offspring = this.synthesis(molecule1, molecule2);
                if (offspring != null) {
                    this.population.set(molecule1Index, offspring);
                    this.population.remove(molecule2Index);
                }
            } else {
                logger.debug("an inter-molecular ineffective collision has occurred");
                Pair<Chromosome, Chromosome> newMolecules = this.intermolecularIneffectiveCollision(molecule1, molecule2);
                if (newMolecules != null) {
                    this.population.set(molecule1Index, newMolecules.getLeft());
                    this.population.set(molecule2Index, newMolecules.getRight());
                }
            }
        }
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        logger.debug("Set up initial population");
        this.generateInitialPopulation(Properties.POPULATION);
        this.calculateFitnessAndSortPopulation();
        this.initialEnergy = this.getCurrentAmountOfEnergy();
        logger.debug("Initial energy is " + this.initialEnergy);
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        if (this.population.isEmpty()) {
            this.initializePopulation();
            assert (!this.population.isEmpty()) : "Initial population is empty, i.e., EvoSuite could not create any test!";
        }
        if (Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER > 0 || Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION) {
            this.disableFirstSecondaryCriterion();
        }
        logger.debug("Starting evolution");
        while (!this.isFinished()) {
            this.elite = this.elitism();
            this.evolve();
            this.applyLocalSearch();
            logger.debug("Updating fitness values");
            this.updateFitnessFunctionsAndValues();
            logger.debug("Current iteration: " + this.currentIteration);
            this.notifyIteration();
            if (Properties.ELITE > 0) {
                for (Chromosome best : this.elite) {
                    int moleculeIndex = Randomness.nextInt(this.population.size());
                    Chromosome molecule = (Chromosome)this.population.get(moleculeIndex);
                    double bestTotalKineticEnergy = best.getKineticEnergy() + best.getFitness();
                    double moleculeTotalKineticEnergy = molecule.getKineticEnergy() + molecule.getFitness();
                    double dif = bestTotalKineticEnergy - moleculeTotalKineticEnergy;
                    best.setKineticEnergy(best.getKineticEnergy() - dif);
                    best.setNumCollisions(molecule.getNumCollisions());
                    this.population.remove(moleculeIndex);
                    this.population.add(best);
                }
                this.sortPopulation();
            }
            double currentEnergy = this.getCurrentAmountOfEnergy();
            if (this.shouldApplyLocalSearch() || Properties.TEST_ARCHIVE) {
                if (currentEnergy > this.initialEnergy) {
                    double delta = currentEnergy - this.initialEnergy;
                    this.buffer -= delta;
                } else if (currentEnergy < this.initialEnergy) {
                    double delta = this.initialEnergy - currentEnergy;
                    this.buffer += delta;
                }
                if (this.buffer < 0.0) {
                    throw new RuntimeException("Amount of energy in the buffer cannot be negative");
                }
                currentEnergy = this.getCurrentAmountOfEnergy();
            }
            if (this.hasEnergyBeenConserved(currentEnergy)) continue;
            throw new RuntimeException("Current amount of energy (" + currentEnergy + ") in the system is not equal to its initial amount of energy (" + this.initialEnergy + "). Conservation of energy has failed!");
        }
        TimeController.execute(this::updateBestIndividualFromArchive, "Update from archive", 5000L);
        this.notifySearchFinished();
    }

    private boolean decompositionCheck(T molecule) {
        return ((Chromosome)molecule).getNumCollisions() > Properties.DECOMPOSITION_THRESHOLD;
    }

    private boolean synthesisCheck(T molecule) {
        return ((Chromosome)molecule).getKineticEnergy() <= (double)Properties.SYNTHESIS_THRESHOLD;
    }

    private T onwallIneffectiveCollision(T molecule) {
        double potencialEnergy = ((Chromosome)molecule).getFitness();
        double kineticEnergy = ((Chromosome)molecule).getKineticEnergy();
        ((Chromosome)molecule).increaseNumCollisionsByOne();
        Object moleculeClone = ((Chromosome)molecule).clone();
        this.notifyMutation(moleculeClone);
        ((Chromosome)moleculeClone).mutate();
        if (!((Chromosome)moleculeClone).isChanged()) {
            logger.debug("Mutation failed to change the individual");
            return null;
        }
        if (this.isTooLong(moleculeClone) || ((Chromosome)moleculeClone).size() == 0) {
            logger.debug("Ignoring individual as it has zero or too many tests");
            return null;
        }
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(moleculeClone);
            this.notifyEvaluation(moleculeClone);
        }
        double potencialEnergyClone = ((Chromosome)moleculeClone).getFitness();
        if (potencialEnergy + kineticEnergy >= potencialEnergyClone) {
            double a = Randomness.nextDouble(Properties.KINETIC_ENERGY_LOSS_RATE, 1.0);
            ((Chromosome)moleculeClone).setKineticEnergy((potencialEnergy - potencialEnergyClone + kineticEnergy) * a);
            this.buffer += (potencialEnergy - potencialEnergyClone + kineticEnergy) * (1.0 - a);
            logger.debug("(" + potencialEnergy + "," + kineticEnergy + ") vs (" + potencialEnergyClone + "," + ((Chromosome)moleculeClone).getKineticEnergy() + ")\nBuffer: " + this.buffer);
            return (T)moleculeClone;
        }
        return null;
    }

    private List<T> decomposition(T molecule) {
        double potencialEnergy = ((Chromosome)molecule).getFitness();
        double kineticEnergy = ((Chromosome)molecule).getKineticEnergy();
        Object offspring1 = ((Chromosome)molecule).clone();
        Object offspring2 = ((Chromosome)molecule).clone();
        this.notifyMutation(offspring1);
        ((Chromosome)offspring1).mutate();
        this.notifyMutation(offspring2);
        ((Chromosome)offspring2).mutate();
        if (!((Chromosome)offspring1).isChanged() && !((Chromosome)offspring2).isChanged()) {
            logger.debug("Mutation failed to change both individuals");
            return null;
        }
        if (this.isTooLong(offspring1) || ((Chromosome)offspring1).size() == 0 || this.isTooLong(offspring2) || ((Chromosome)offspring2).size() == 0) {
            logger.debug("Ignoring individuals as at least one has zero or too many tests");
            return null;
        }
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(offspring1);
            this.notifyEvaluation(offspring1);
            fitnessFunction.getFitness(offspring2);
            this.notifyEvaluation(offspring2);
        }
        double potencialEnergy1 = ((Chromosome)offspring1).getFitness();
        double potencialEnergy2 = ((Chromosome)offspring2).getFitness();
        boolean decomposed = false;
        if (potencialEnergy + kineticEnergy >= potencialEnergy1 + potencialEnergy2) {
            double eDec = potencialEnergy + kineticEnergy - (potencialEnergy1 + potencialEnergy2);
            this.updateMoleculesAfterDecomposition(offspring1, offspring2, eDec);
            decomposed = true;
        } else {
            double delta2;
            double delta1 = Randomness.nextDouble();
            double eDec = potencialEnergy + kineticEnergy + delta1 * (delta2 = Randomness.nextDouble()) * this.buffer - (potencialEnergy1 + potencialEnergy2);
            if (eDec >= 0.0) {
                this.buffer *= 1.0 - delta1 * delta2;
                this.updateMoleculesAfterDecomposition(offspring1, offspring2, eDec);
                decomposed = true;
            } else {
                ((Chromosome)molecule).increaseNumCollisionsByOne();
                decomposed = false;
            }
        }
        if (decomposed) {
            ArrayList<Object> offsprings = new ArrayList<Object>(2);
            offsprings.add(offspring1);
            offsprings.add(offspring2);
            logger.debug("(" + potencialEnergy + "," + kineticEnergy + ") vs (" + potencialEnergy1 + "," + ((Chromosome)offspring1).getKineticEnergy() + ") --- (" + potencialEnergy2 + "," + ((Chromosome)offspring2).getKineticEnergy() + ")\nBuffer: " + this.buffer + " of " + this.initialEnergy);
            return offsprings;
        }
        return null;
    }

    private void updateMoleculesAfterDecomposition(T moleculeClone1, T moleculeClone2, double eDec) {
        double delta3 = Randomness.nextDouble();
        ((Chromosome)moleculeClone1).setKineticEnergy(eDec * delta3);
        ((Chromosome)moleculeClone2).setKineticEnergy(eDec * (1.0 - delta3));
        ((Chromosome)moleculeClone1).resetNumCollisions();
        ((Chromosome)moleculeClone2).resetNumCollisions();
    }

    private Pair<T, T> intermolecularIneffectiveCollision(T molecule1, T molecule2) {
        double potencialEnergyClone2;
        double potencialEnergy1 = ((Chromosome)molecule1).getFitness();
        double kineticEnergy1 = ((Chromosome)molecule1).getKineticEnergy();
        ((Chromosome)molecule1).increaseNumCollisionsByOne();
        double potencialEnergy2 = ((Chromosome)molecule2).getFitness();
        double kineticEnergy2 = ((Chromosome)molecule2).getKineticEnergy();
        ((Chromosome)molecule2).increaseNumCollisionsByOne();
        Object moleculeClone1 = ((Chromosome)molecule1).clone();
        Object moleculeClone2 = ((Chromosome)molecule2).clone();
        this.notifyMutation(moleculeClone1);
        ((Chromosome)moleculeClone1).mutate();
        this.notifyMutation(moleculeClone2);
        ((Chromosome)moleculeClone2).mutate();
        if (!((Chromosome)moleculeClone1).isChanged() && !((Chromosome)moleculeClone2).isChanged()) {
            logger.debug("Mutation failed to change both individuals");
            return null;
        }
        if (this.isTooLong(moleculeClone1) || ((Chromosome)moleculeClone1).size() == 0 || this.isTooLong(moleculeClone2) || ((Chromosome)moleculeClone2).size() == 0) {
            logger.debug("Ignoring individuals as at least one has zero or too many tests");
            return null;
        }
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(moleculeClone1);
            this.notifyEvaluation(moleculeClone1);
            fitnessFunction.getFitness(moleculeClone2);
            this.notifyEvaluation(moleculeClone2);
        }
        double potencialEnergyClone1 = ((Chromosome)moleculeClone1).getFitness();
        double eInter = potencialEnergy1 + potencialEnergy2 + kineticEnergy1 + kineticEnergy2 - (potencialEnergyClone1 + (potencialEnergyClone2 = ((Chromosome)moleculeClone2).getFitness()));
        if (eInter >= 0.0) {
            double delta4 = Randomness.nextDouble();
            ((Chromosome)moleculeClone1).setKineticEnergy(eInter * delta4);
            ((Chromosome)moleculeClone2).setKineticEnergy(eInter * (1.0 - delta4));
            logger.debug("(" + potencialEnergy1 + "," + kineticEnergy1 + ") vs (" + potencialEnergyClone1 + "," + ((Chromosome)moleculeClone1).getKineticEnergy() + ")\n(" + potencialEnergy2 + "," + kineticEnergy2 + ") vs (" + potencialEnergyClone2 + "," + ((Chromosome)moleculeClone2).getKineticEnergy() + ")\nBuffer: " + this.buffer);
            return new ImmutablePair<Object, Object>(moleculeClone1, moleculeClone2);
        }
        return null;
    }

    private T synthesis(T molecule1, T molecule2) {
        double potencialEnergy1 = ((Chromosome)molecule1).getFitness();
        double kineticEnergy1 = ((Chromosome)molecule1).getKineticEnergy();
        double potencialEnergy2 = ((Chromosome)molecule2).getFitness();
        double kineticEnergy2 = ((Chromosome)molecule2).getKineticEnergy();
        Object offspring1 = ((Chromosome)molecule1).clone();
        Object offspring2 = ((Chromosome)molecule2).clone();
        try {
            this.crossoverFunction.crossOver(offspring1, offspring2);
        }
        catch (ConstructionFailedException e) {
            logger.debug("CrossOver failed");
            logger.debug(e.toString());
            return null;
        }
        if (!((Chromosome)offspring1).isChanged() && !((Chromosome)offspring2).isChanged()) {
            logger.debug("Crossover failed to change both individuals");
            return null;
        }
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(offspring1);
            this.notifyEvaluation(offspring1);
            fitnessFunction.getFitness(offspring2);
            this.notifyEvaluation(offspring2);
        }
        Object offspring = ((Chromosome)offspring1).getFitness() < ((Chromosome)offspring2).getFitness() ? offspring1 : offspring2;
        double potencialEnergy = ((Chromosome)offspring).getFitness();
        if (potencialEnergy1 + potencialEnergy2 + kineticEnergy1 + kineticEnergy2 >= potencialEnergy) {
            ((Chromosome)offspring).setKineticEnergy(potencialEnergy1 + potencialEnergy2 + kineticEnergy1 + kineticEnergy2 - potencialEnergy);
            ((Chromosome)offspring).resetNumCollisions();
            logger.debug("(" + potencialEnergy1 + "," + kineticEnergy1 + ") --- (" + potencialEnergy2 + "," + kineticEnergy2 + ") vs (" + potencialEnergy + "," + ((Chromosome)offspring).getKineticEnergy() + ")\nBuffer: " + this.buffer);
            return (T)offspring;
        }
        ((Chromosome)molecule1).increaseNumCollisionsByOne();
        ((Chromosome)molecule2).increaseNumCollisionsByOne();
        return null;
    }

    private double getCurrentAmountOfEnergy() {
        double energy = this.buffer;
        for (Chromosome t : this.population) {
            energy += t.getFitness() + t.getKineticEnergy();
        }
        return energy;
    }

    private boolean hasEnergyBeenConserved(double energy) {
        return Math.abs(this.initialEnergy - energy) < 1.0E-9;
    }
}

