/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardGA<T extends Chromosome<T>>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 5043503777821916152L;
    private final Logger logger = LoggerFactory.getLogger(StandardGA.class);

    public StandardGA(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        ArrayList newGeneration = new ArrayList(this.elitism());
        while (!this.isNextPopulationFull(newGeneration)) {
            Object offspring2;
            Object offspring1;
            Object parent2;
            Object parent1;
            block8: {
                parent1 = this.selectionFunction.select(this.population);
                parent2 = this.selectionFunction.select(this.population);
                offspring1 = ((Chromosome)parent1).clone();
                offspring2 = ((Chromosome)parent2).clone();
                try {
                    if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                        this.crossoverFunction.crossOver(offspring1, offspring2);
                    }
                    this.notifyMutation(offspring1);
                    ((Chromosome)offspring1).mutate();
                    this.notifyMutation(offspring2);
                    ((Chromosome)offspring2).mutate();
                    if (((Chromosome)offspring1).isChanged()) {
                        ((Chromosome)offspring1).updateAge(this.currentIteration);
                    }
                    if (!((Chromosome)offspring2).isChanged()) break block8;
                    ((Chromosome)offspring2).updateAge(this.currentIteration);
                }
                catch (ConstructionFailedException e) {
                    this.logger.info("CrossOver/Mutation failed.");
                    continue;
                }
            }
            if (!this.isTooLong(offspring1)) {
                newGeneration.add(offspring1);
            } else {
                newGeneration.add(parent1);
            }
            if (!this.isTooLong(offspring2)) {
                newGeneration.add(offspring2);
                continue;
            }
            newGeneration.add(parent2);
        }
        this.population = newGeneration;
        this.updateFitnessFunctionsAndValues();
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.calculateFitnessAndSortPopulation();
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        if (Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER > 0 || Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION) {
            this.disableFirstSecondaryCriterion();
        }
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        this.logger.debug("Starting evolution");
        int starvationCounter = 0;
        double bestFitness = Double.MAX_VALUE;
        double lastBestFitness = Double.MAX_VALUE;
        if (this.getFitnessFunction().isMaximizationFunction()) {
            bestFitness = 0.0;
            lastBestFitness = 0.0;
        }
        while (!this.isFinished()) {
            this.logger.debug("Current population: " + this.getAge() + "/" + Properties.SEARCH_BUDGET);
            this.logger.info("Best fitness: " + ((Chromosome)this.getBestIndividual()).getFitness());
            this.evolve();
            this.calculateFitnessAndSortPopulation();
            this.applyLocalSearch();
            double newFitness = ((Chromosome)this.getBestIndividual()).getFitness();
            if (this.getFitnessFunction().isMaximizationFunction() ? !$assertionsDisabled && !(newFitness >= bestFitness) : !$assertionsDisabled && !(newFitness <= bestFitness)) {
                throw new AssertionError((Object)("best fitness was: " + bestFitness + ", now best fitness is " + newFitness));
            }
            bestFitness = newFitness;
            if (Double.compare(bestFitness, lastBestFitness) == 0) {
                ++starvationCounter;
            } else {
                this.logger.info("reset starvationCounter after " + starvationCounter + " iterations");
                starvationCounter = 0;
                lastBestFitness = bestFitness;
            }
            this.updateSecondaryCriterion(starvationCounter);
            this.notifyIteration();
        }
        this.updateBestIndividualFromArchive();
        this.notifySearchFinished();
    }
}

