/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mapelites;

import java.io.Serializable;
import java.util.Arrays;
import org.evosuite.assertion.Inspector;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;

public final class FeatureVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Entry[] features;

    public FeatureVector(Inspector[] inspectors, Object instance) {
        this.features = new Entry[inspectors.length];
        for (int i = 0; i < inspectors.length; ++i) {
            this.features[i] = new Entry(inspectors[i], instance);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.features);
    }

    public boolean equals(FeatureVector other) {
        return Arrays.equals(this.features, other.features);
    }

    public boolean equals(Object obj) {
        return obj instanceof FeatureVector && this.equals((FeatureVector)obj);
    }

    public String toString() {
        return Arrays.toString(this.features);
    }

    private static int getPossibilityCountForType(Class<?> type) {
        Class<?> wrappedType = ClassUtils.primitiveToWrapper(type);
        int amount = 0;
        if (Character.class.isAssignableFrom(wrappedType)) {
            amount = 1;
        } else if (Boolean.class.isAssignableFrom(wrappedType)) {
            amount = 2;
        } else if (String.class.isAssignableFrom(wrappedType)) {
            amount = 2;
        } else if (wrappedType.isEnum()) {
            amount = wrappedType.getEnumConstants().length;
        } else if (Number.class.isAssignableFrom(wrappedType)) {
            amount = 3;
        }
        if (!type.isPrimitive()) {
            ++amount;
        }
        return amount;
    }

    public static int getPossibilityCount(Inspector[] inspectors) {
        return Arrays.stream(inspectors).mapToInt(i -> FeatureVector.getPossibilityCountForType(i.getReturnType())).reduce(1, Math::multiplyExact);
    }

    private final class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Object value;
        private final int group;

        public Entry(Inspector inspector, Object instance) {
            Object value;
            try {
                value = inspector.getValue(instance);
            }
            catch (Exception e) {
                value = null;
            }
            this.value = value;
            this.name = inspector.getMethodCall();
            this.group = this.calculateGroup();
        }

        public int getGroup() {
            return this.group;
        }

        private int calculateGroup() {
            if (this.value == null) {
                return 0;
            }
            if (this.value instanceof Integer) {
                return ((Integer)this.value).compareTo(0);
            }
            if (this.value instanceof Short) {
                return ((Short)this.value).compareTo((short)0);
            }
            if (this.value instanceof Byte) {
                return ((Byte)this.value).compareTo((byte)0);
            }
            if (this.value instanceof Long) {
                return ((Long)this.value).compareTo(0L);
            }
            if (this.value instanceof Float) {
                return ((Float)this.value).compareTo(Float.valueOf(0.0f));
            }
            if (this.value instanceof Double) {
                return ((Double)this.value).compareTo(0.0);
            }
            if (this.value instanceof String) {
                return ((String)this.value).isEmpty() ? 0 : 1;
            }
            if (this.value instanceof Character) {
                return Character.isLetterOrDigit(((Character)this.value).charValue()) ? 1 : 0;
            }
            if (this.value instanceof Boolean) {
                return (Boolean)this.value != false ? 1 : 0;
            }
            if (this.value instanceof Enum) {
                return ((Enum)this.value).ordinal();
            }
            throw new RuntimeException("Unsupported type: " + this.value.getClass().getName());
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        public int hashCode() {
            return this.getGroup() * this.name.hashCode();
        }

        public boolean equals(Entry other) {
            return this.getGroup() == other.getGroup() && this.name.equals(other.name);
        }

        public boolean equals(Object obj) {
            return obj instanceof Entry && this.equals((Entry)obj);
        }
    }
}

