/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.comparators.DominanceComparator;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.mosa.MOSATestSuiteAdapter;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.secondaryobjectives.TestCaseSecondaryObjective;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.BudgetConsumptionMonitor;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMOSA
extends GeneticAlgorithm<TestChromosome> {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractMOSA.class);
    protected final List<TestFitnessFunction> fitnessFunctions = new ArrayList<TestFitnessFunction>();
    private MOSATestSuiteAdapter adapter = null;
    public final Map<TestSuiteFitnessFunction, Class<?>> suiteFitnessFunctions = new LinkedHashMap();
    protected final BudgetConsumptionMonitor budgetMonitor;

    public AbstractMOSA(ChromosomeFactory<TestChromosome> factory) {
        super(factory);
        for (Properties.Criterion criterion : Properties.CRITERION) {
            TestSuiteFitnessFunction suiteFit = FitnessFunctions.getFitnessFunction(criterion);
            Class<?> testFit = FitnessFunctions.getTestFitnessFunctionClass(criterion);
            this.suiteFitnessFunctions.put(suiteFit, testFit);
        }
        this.budgetMonitor = new BudgetConsumptionMonitor();
        TestCaseSecondaryObjective.setSecondaryObjectives();
        if (Properties.SELECTION_FUNCTION != Properties.SelectionFunction.RANK_CROWD_DISTANCE_TOURNAMENT) {
            LoggingUtils.getEvoLogger().warn("Originally, MOSA was implemented with a '" + Properties.SelectionFunction.RANK_CROWD_DISTANCE_TOURNAMENT.name() + "' selection function. You may want to consider using it.");
        }
    }

    public void setAdapter(MOSATestSuiteAdapter adapter) {
        Objects.requireNonNull(adapter);
        if (this.adapter != null) {
            throw new IllegalStateException("adapter has already been set");
        }
        this.adapter = adapter;
    }

    @Override
    public void addFitnessFunction(FitnessFunction<TestChromosome> function) {
        if (!(function instanceof TestFitnessFunction)) {
            throw new IllegalArgumentException("Only TestFitnessFunctions are supported");
        }
        this.fitnessFunctions.add((TestFitnessFunction)function);
    }

    @Override
    public FitnessFunction<TestChromosome> getFitnessFunction() {
        return this.fitnessFunctions.get(0);
    }

    @Override
    public List<? extends FitnessFunction<TestChromosome>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }

    protected List<TestChromosome> breedNextGeneration() {
        int i;
        ArrayList<TestChromosome> offspringPopulation = new ArrayList<TestChromosome>(Properties.POPULATION);
        for (i = 0; i < Properties.POPULATION / 2 && !this.isFinished(); ++i) {
            TestChromosome parent1 = (TestChromosome)this.selectionFunction.select(this.population);
            TestChromosome parent2 = (TestChromosome)this.selectionFunction.select(this.population);
            TestChromosome offspring1 = parent1.clone();
            TestChromosome offspring2 = parent2.clone();
            if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                try {
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
                catch (ConstructionFailedException e) {
                    logger.debug("CrossOver failed.");
                    continue;
                }
            }
            this.removeUnusedVariables(offspring1);
            this.removeUnusedVariables(offspring2);
            this.mutate(offspring1, parent1);
            if (offspring1.isChanged()) {
                this.clearCachedResults(offspring1);
                offspring1.updateAge(this.currentIteration);
                this.calculateFitness(offspring1);
                offspringPopulation.add(offspring1);
            }
            this.mutate(offspring2, parent2);
            if (!offspring2.isChanged()) continue;
            this.clearCachedResults(offspring2);
            offspring2.updateAge(this.currentIteration);
            this.calculateFitness(offspring2);
            offspringPopulation.add(offspring2);
        }
        i = 0;
        while ((double)i < (double)Properties.POPULATION * Properties.P_TEST_INSERTION) {
            TestChromosome tch;
            if (this.getCoveredGoals().size() == 0 || Randomness.nextBoolean()) {
                tch = (TestChromosome)this.chromosomeFactory.getChromosome();
                tch.setChanged(true);
            } else {
                tch = Randomness.choice(this.getSolutions()).clone();
                tch.mutate();
            }
            if (tch.isChanged()) {
                tch.updateAge(this.currentIteration);
                this.calculateFitness(tch);
                offspringPopulation.add(tch);
            }
            ++i;
        }
        logger.info("Number of offsprings = {}", (Object)offspringPopulation.size());
        return offspringPopulation;
    }

    private void mutate(TestChromosome offspring, TestChromosome parent) {
        offspring.mutate();
        if (!offspring.isChanged()) {
            offspring.mutate();
        }
        if (!this.hasMethodCall(offspring)) {
            offspring.setTestCase(parent.getTestCase().clone());
            boolean changed = offspring.mutationInsert();
            if (changed) {
                offspring.getTestCase().forEach(Statement::isValid);
            }
            offspring.setChanged(changed);
        }
        this.notifyMutation(offspring);
    }

    private boolean hasMethodCall(TestChromosome test) {
        boolean flag = false;
        TestCase tc = test.getTestCase();
        for (Statement s : tc) {
            EntityWithParametersStatement ms;
            boolean isTargetMethod;
            if (s instanceof MethodStatement && (isTargetMethod = ((MethodStatement)(ms = (MethodStatement)s)).getDeclaringClassName().equals(Properties.TARGET_CLASS))) {
                return true;
            }
            if (!(s instanceof ConstructorStatement) || !(isTargetMethod = ((ConstructorStatement)(ms = (ConstructorStatement)s)).getDeclaringClassName().equals(Properties.TARGET_CLASS))) continue;
            return true;
        }
        return flag;
    }

    private void clearCachedResults(TestChromosome chromosome) {
        chromosome.clearCachedMutationResults();
        chromosome.clearCachedResults();
        chromosome.clearMutationHistory();
        chromosome.getFitnessValues().clear();
    }

    private boolean removeUnusedVariables(TestChromosome chromosome) {
        int sizeBefore = chromosome.size();
        TestCase t = chromosome.getTestCase();
        ArrayList<Integer> toDelete = new ArrayList<Integer>(chromosome.size());
        boolean hasDeleted = false;
        int num = 0;
        for (Statement s : t) {
            boolean delete;
            VariableReference var = s.getReturnValue();
            boolean bl = delete = s instanceof PrimitiveStatement || s instanceof ArrayStatement;
            if (!t.hasReferences(var) && delete) {
                toDelete.add(num);
                hasDeleted = true;
            }
            ++num;
        }
        toDelete.sort(Collections.reverseOrder());
        Iterator<Object> iterator = toDelete.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            t.remove(position);
        }
        int sizeAfter = chromosome.size();
        if (hasDeleted) {
            logger.debug("Removed {} unused statements", (Object)(sizeBefore - sizeAfter));
        }
        return hasDeleted;
    }

    public List<TestChromosome> getNonDominatedSolutions(List<TestChromosome> solutions) {
        DominanceComparator<TestChromosome> comparator = new DominanceComparator<TestChromosome>(this.getCoveredGoals());
        ArrayList<TestChromosome> nextFront = new ArrayList<TestChromosome>(solutions.size());
        for (TestChromosome p : solutions) {
            boolean isDominated = false;
            ArrayList<TestChromosome> dominatedSolutions = new ArrayList<TestChromosome>(solutions.size());
            for (TestChromosome best : nextFront) {
                int flag = comparator.compare(p, best);
                if (flag < 0) {
                    dominatedSolutions.add(best);
                }
                if (flag <= 0) continue;
                isDominated = true;
            }
            if (isDominated) continue;
            nextFront.add(p);
            nextFront.removeAll(dominatedSolutions);
        }
        return nextFront;
    }

    @Override
    public void initializePopulation() {
        logger.info("executing initializePopulation function");
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.calculateFitness();
        this.notifyIteration();
    }

    protected Set<TestFitnessFunction> getCoveredGoals() {
        return new LinkedHashSet<TestFitnessFunction>(Archive.getArchiveInstance().getCoveredTargets());
    }

    protected int getNumberOfCoveredGoals() {
        return Archive.getArchiveInstance().getNumberOfCoveredTargets();
    }

    protected void addUncoveredGoal(TestFitnessFunction goal) {
        Archive.getArchiveInstance().addTarget(goal);
    }

    protected Set<TestFitnessFunction> getUncoveredGoals() {
        return new LinkedHashSet<TestFitnessFunction>(Archive.getArchiveInstance().getUncoveredTargets());
    }

    protected int getNumberOfUncoveredGoals() {
        return Archive.getArchiveInstance().getNumberOfUncoveredTargets();
    }

    protected int getTotalNumberOfGoals() {
        return Archive.getArchiveInstance().getNumberOfTargets();
    }

    protected List<TestChromosome> getSolutions() {
        return new ArrayList<TestChromosome>(Archive.getArchiveInstance().getSolutions());
    }

    public TestSuiteChromosome generateSuite() {
        TestSuiteChromosome suite = new TestSuiteChromosome();
        Archive.getArchiveInstance().getSolutions().forEach(suite::addTest);
        return suite;
    }

    @Override
    protected void notifySearchStarted() {
        super.notifySearchStarted();
    }

    @Override
    protected void notifyIteration() {
        super.notifyIteration();
    }

    @Override
    protected void notifySearchFinished() {
        super.notifySearchFinished();
    }

    @Override
    protected void calculateFitness(TestChromosome c) {
        this.fitnessFunctions.forEach(fitnessFunction -> fitnessFunction.getFitness(c));
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.EXCEPTION)) {
            ExceptionCoverageSuiteFitness.calculateExceptionInfo(Collections.singletonList(c.getLastExecutionResult()), new HashMap(), new HashMap(), new HashMap(), new ExceptionCoverageSuiteFitness());
        }
        this.notifyEvaluation(c);
        this.budgetMonitor.checkMaxCoverage(this.getNumberOfCoveredGoals());
    }

    @Override
    public List<TestChromosome> getBestIndividuals() {
        return this.getNonDominatedSolutions(this.population);
    }

    protected void applyLocalSearch(TestSuiteChromosome testSuite) {
        this.adapter.applyLocalSearch(testSuite);
    }
}

