/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.comparators.OnlyCrowdingComparator;
import org.evosuite.ga.metaheuristics.mosa.AbstractMOSA;
import org.evosuite.ga.metaheuristics.mosa.structural.MultiCriteriaManager;
import org.evosuite.ga.operators.ranking.CrowdingDistance;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynaMOSA
extends AbstractMOSA {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(DynaMOSA.class);
    protected MultiCriteriaManager goalsManager = null;
    protected CrowdingDistance<TestChromosome> distance = new CrowdingDistance();

    public DynaMOSA(ChromosomeFactory<TestChromosome> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        List<TestChromosome> offspringPopulation = this.breedNextGeneration();
        ArrayList<TestChromosome> union = new ArrayList<TestChromosome>(this.population.size() + offspringPopulation.size());
        union.addAll(this.population);
        union.addAll(offspringPopulation);
        logger.debug("Union Size = {}", (Object)union.size());
        this.rankingFunction.computeRankingAssignment(union, this.goalsManager.getCurrentGoals());
        int remain = Math.max(Properties.POPULATION, this.rankingFunction.getSubfront(0).size());
        int index = 0;
        this.population.clear();
        List front = this.rankingFunction.getSubfront(index);
        while (remain > 0 && remain >= front.size() && !front.isEmpty()) {
            this.distance.fastEpsilonDominanceAssignment(front, this.goalsManager.getCurrentGoals());
            this.population.addAll(front);
            ++index;
            if ((remain -= front.size()) <= 0) continue;
            front = this.rankingFunction.getSubfront(index);
        }
        if (remain > 0 && !front.isEmpty()) {
            this.distance.fastEpsilonDominanceAssignment(front, this.goalsManager.getCurrentGoals());
            front.sort(new OnlyCrowdingComparator());
            for (int k = 0; k < remain; ++k) {
                this.population.add(front.get(k));
            }
        }
        ++this.currentIteration;
        logger.debug("Covered goals = {}", (Object)this.goalsManager.getCoveredGoals().size());
        logger.debug("Current goals = {}", (Object)this.goalsManager.getCurrentGoals().size());
        logger.debug("Uncovered goals = {}", (Object)this.goalsManager.getUncoveredGoals().size());
    }

    @Override
    public void generateSolution() {
        logger.debug("executing generateSolution function");
        this.goalsManager = new MultiCriteriaManager(this.fitnessFunctions);
        LoggingUtils.getEvoLogger().info("* Initial Number of Goals in DynaMOSA = " + this.goalsManager.getCurrentGoals().size() + " / " + this.getUncoveredGoals().size());
        logger.debug("Initial Number of Goals = " + this.goalsManager.getCurrentGoals().size());
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        this.rankingFunction.computeRankingAssignment(this.population, this.goalsManager.getCurrentGoals());
        for (int i = 0; i < this.rankingFunction.getNumberOfSubfronts(); ++i) {
            this.distance.fastEpsilonDominanceAssignment(this.rankingFunction.getSubfront(i), this.goalsManager.getCurrentGoals());
        }
        while (!this.isFinished() && this.goalsManager.getUncoveredGoals().size() > 0) {
            this.evolve();
            this.notifyIteration();
        }
        this.notifySearchFinished();
    }

    @Override
    protected void calculateFitness(TestChromosome c) {
        if (!this.isFinished()) {
            this.goalsManager.calculateFitness(c, this);
            this.notifyEvaluation(c);
        }
    }
}

