/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.evosuite.ClientProcess;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.comparators.OnlyCrowdingComparator;
import org.evosuite.ga.metaheuristics.mosa.AbstractMOSA;
import org.evosuite.ga.operators.ranking.CrowdingDistance;
import org.evosuite.ga.operators.selection.BestKSelection;
import org.evosuite.ga.operators.selection.RandomKSelection;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientNodeLocal;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.utils.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MOSA
extends AbstractMOSA {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(MOSA.class);
    private final ConcurrentLinkedQueue<List<TestChromosome>> immigrants = new ConcurrentLinkedQueue();
    private final SelectionFunction<TestChromosome> emigrantsSelection;
    protected CrowdingDistance<TestChromosome> distance = new CrowdingDistance();

    public MOSA(ChromosomeFactory<TestChromosome> factory) {
        super(factory);
        switch (Properties.EMIGRANT_SELECTION_FUNCTION) {
            case RANK: {
                this.emigrantsSelection = new RankSelection<TestChromosome>();
                break;
            }
            case RANDOMK: {
                this.emigrantsSelection = new RandomKSelection<TestChromosome>();
                break;
            }
            default: {
                this.emigrantsSelection = new BestKSelection<TestChromosome>();
            }
        }
    }

    @Override
    protected void evolve() {
        List<TestChromosome> offspringPopulation = this.breedNextGeneration();
        ArrayList<TestChromosome> union = new ArrayList<TestChromosome>();
        union.addAll(this.population);
        union.addAll(offspringPopulation);
        if (Properties.NUM_PARALLEL_CLIENTS > 1 && !this.immigrants.isEmpty()) {
            union.addAll((Collection)this.immigrants.poll());
        }
        Set<TestFitnessFunction> uncoveredGoals = this.getUncoveredGoals();
        logger.debug("Union Size =" + union.size());
        this.rankingFunction.computeRankingAssignment(union, uncoveredGoals);
        int remain = this.population.size();
        int index = 0;
        List front = null;
        this.population.clear();
        front = this.rankingFunction.getSubfront(index);
        while (remain > 0 && remain >= front.size() && !front.isEmpty()) {
            this.distance.fastEpsilonDominanceAssignment(front, uncoveredGoals);
            this.population.addAll(front);
            ++index;
            if ((remain -= front.size()) <= 0) continue;
            front = this.rankingFunction.getSubfront(index);
        }
        if (remain > 0 && !front.isEmpty()) {
            this.distance.fastEpsilonDominanceAssignment(front, uncoveredGoals);
            front.sort(new OnlyCrowdingComparator());
            for (int k = 0; k < remain; ++k) {
                this.population.add(front.get(k));
            }
            remain = 0;
        }
        if (Properties.NUM_PARALLEL_CLIENTS > 1 && Properties.MIGRANTS_ITERATION_FREQUENCY > 0 && (this.currentIteration + 1) % Properties.MIGRANTS_ITERATION_FREQUENCY == 0 && !this.population.isEmpty()) {
            HashSet<TestChromosome> emigrants = new HashSet<TestChromosome>(this.emigrantsSelection.select(this.population, Properties.MIGRANTS_COMMUNICATION_RATE));
            ClientServices.getInstance().getClientNode().emigrate(emigrants);
        }
        ++this.currentIteration;
    }

    @Override
    public void generateSolution() {
        logger.info("executing generateSolution function");
        this.fitnessFunctions.forEach(this::addUncoveredGoal);
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        this.rankingFunction.computeRankingAssignment(this.population, this.getUncoveredGoals());
        for (int i = 0; i < this.rankingFunction.getNumberOfSubfronts(); ++i) {
            this.distance.fastEpsilonDominanceAssignment(this.rankingFunction.getSubfront(i), this.getUncoveredGoals());
        }
        ClientNodeLocal<Object> clientNode = ClientServices.getInstance().getClientNode();
        Listener<Set> listener = null;
        if (Properties.NUM_PARALLEL_CLIENTS > 1) {
            listener = event -> this.immigrants.add(new LinkedList(event));
            clientNode.addListener(listener);
        }
        while (!this.isFinished() && this.getNumberOfUncoveredGoals() > 0) {
            this.evolve();
            this.notifyIteration();
        }
        if (Properties.NUM_PARALLEL_CLIENTS > 1) {
            clientNode.deleteListener(listener);
            if ("Client-0".equals(ClientProcess.getIdentifier())) {
                Set collectedSolutions = clientNode.getBestSolutions();
                logger.debug("Client-0: Received " + collectedSolutions.size() + " solution sets");
                for (Set solution : collectedSolutions) {
                    for (TestChromosome t : solution) {
                        this.calculateFitness(t);
                    }
                }
            } else {
                HashSet<TestChromosome> solutionsSet = new HashSet<TestChromosome>(this.getSolutions());
                logger.debug(ClientProcess.getPrettyPrintIdentifier() + "Sending " + solutionsSet.size() + " solutions to " + "Client-0");
                clientNode.sendBestSolution(solutionsSet);
            }
        }
        clientNode.trackOutputVariable(RuntimeVariable.Time2MaxCoverage, this.budgetMonitor.getTime2MaxCoverage());
        this.notifySearchFinished();
    }
}

