/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.metaheuristics.TestSuiteAdapter;
import org.evosuite.ga.metaheuristics.mosa.AbstractMOSA;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class MOSATestSuiteAdapter
extends TestSuiteAdapter<AbstractMOSA> {
    private static final long serialVersionUID = 1556980428376303737L;

    public MOSATestSuiteAdapter(AbstractMOSA algorithm) {
        super(algorithm);
        algorithm.setAdapter(this);
    }

    @Override
    public List<TestSuiteChromosome> getBestIndividuals() {
        TestSuiteChromosome bestTestCases = Archive.getArchiveInstance().mergeArchiveAndSolution(new TestSuiteChromosome());
        if (bestTestCases.getTestChromosomes().isEmpty()) {
            for (TestChromosome test : ((AbstractMOSA)this.getAlgorithm()).getBestIndividuals()) {
                bestTestCases.addTest(test);
            }
        }
        this.computeCoverageAndFitness(bestTestCases);
        return Collections.singletonList(bestTestCases);
    }

    @Override
    public TestSuiteChromosome getBestIndividual() {
        TestSuiteChromosome best = ((AbstractMOSA)this.getAlgorithm()).generateSuite();
        if (best.getTestChromosomes().isEmpty()) {
            for (TestChromosome test : ((AbstractMOSA)this.getAlgorithm()).getBestIndividuals()) {
                best.addTest(test);
            }
            for (TestSuiteFitnessFunction suiteFitness : ((AbstractMOSA)this.getAlgorithm()).suiteFitnessFunctions.keySet()) {
                best.setCoverage(suiteFitness, 0.0);
                best.setFitness(suiteFitness, 1.0);
            }
            return best;
        }
        this.computeCoverageAndFitness(best);
        return best;
    }

    protected void computeCoverageAndFitness(TestSuiteChromosome suite) {
        for (Map.Entry<TestSuiteFitnessFunction, Class<?>> entry : ((AbstractMOSA)this.getAlgorithm()).suiteFitnessFunctions.entrySet()) {
            int numberUncoveredTargets;
            TestSuiteFitnessFunction suiteFitnessFunction = entry.getKey();
            Class<?> testFitnessFunction = entry.getValue();
            int numberCoveredTargets = Archive.getArchiveInstance().getNumberOfCoveredTargets(testFitnessFunction);
            int totalNumberTargets = numberCoveredTargets + (numberUncoveredTargets = Archive.getArchiveInstance().getNumberOfUncoveredTargets(testFitnessFunction));
            double coverage = totalNumberTargets == 0 ? 1.0 : (double)numberCoveredTargets / (double)totalNumberTargets;
            suite.setFitness(suiteFitnessFunction, numberUncoveredTargets);
            suite.setCoverage(suiteFitnessFunction, coverage);
            suite.setNumOfCoveredGoals(suiteFitnessFunction, numberCoveredTargets);
            suite.setNumOfNotCoveredGoals(suiteFitnessFunction, numberUncoveredTargets);
        }
    }

    void applyLocalSearch(TestSuiteChromosome testSuite) {
        this.population = new LinkedList();
        this.population.add(testSuite);
        super.applyLocalSearch();
        this.population = null;
    }
}

