/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.structural;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.mosa.structural.BranchFitnessGraph;
import org.evosuite.ga.metaheuristics.mosa.structural.StructuralGoalManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchesManager
extends StructuralGoalManager {
    private static final Logger logger = LoggerFactory.getLogger(BranchesManager.class);
    private static final long serialVersionUID = 6453893627503159175L;
    protected BranchFitnessGraph graph;
    protected final Map<Integer, TestFitnessFunction> branchCoverageTrueMap = new HashMap<Integer, TestFitnessFunction>();
    protected final Map<Integer, TestFitnessFunction> branchCoverageFalseMap = new HashMap<Integer, TestFitnessFunction>();
    private final Map<String, TestFitnessFunction> branchlessMethodCoverageMap = new HashMap<String, TestFitnessFunction>();

    public BranchesManager(List<TestFitnessFunction> fitnessFunctions) {
        super(fitnessFunctions);
        this.graph = new BranchFitnessGraph(new HashSet<TestFitnessFunction>(fitnessFunctions));
        this.currentGoals.addAll(this.graph.getRootBranches());
        for (TestFitnessFunction ff : fitnessFunctions) {
            BranchCoverageTestFitness goal = (BranchCoverageTestFitness)ff;
            if (goal.getBranch() != null && goal.getBranch().isInstrumented()) continue;
            if (goal.getBranch() == null) {
                this.branchlessMethodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), ff);
                continue;
            }
            if (goal.getBranchExpressionValue()) {
                this.branchCoverageTrueMap.put(goal.getBranch().getActualBranchId(), ff);
                continue;
            }
            this.branchCoverageFalseMap.put(goal.getBranch().getActualBranchId(), ff);
        }
    }

    @Override
    public void calculateFitness(TestChromosome c, GeneticAlgorithm<TestChromosome> ga) {
        TestCase test = c.getTestCase();
        ExecutionResult result = TestCaseExecutor.runTest(test);
        c.setLastExecutionResult(result);
        c.setChanged(false);
        if (result.hasTimeout() || result.hasTestException()) {
            this.currentGoals.forEach(f -> c.setFitness(f, Double.MAX_VALUE));
            return;
        }
        HashSet<TestFitnessFunction> visitedStatements = new HashSet<TestFitnessFunction>(this.getUncoveredGoals().size() * 2);
        LinkedList<TestFitnessFunction> targets = new LinkedList<TestFitnessFunction>(this.currentGoals);
        while (targets.size() > 0 && !ga.isFinished()) {
            TestFitnessFunction fitnessFunction = (TestFitnessFunction)targets.poll();
            int pastSize = visitedStatements.size();
            visitedStatements.add(fitnessFunction);
            if (pastSize == visitedStatements.size()) continue;
            double value = fitnessFunction.getFitness(c);
            if (value == 0.0) {
                this.updateCoveredGoals(fitnessFunction, c);
                for (TestFitnessFunction child : this.graph.getStructuralChildren(fitnessFunction)) {
                    targets.addLast(child);
                }
                continue;
            }
            this.currentGoals.add(fitnessFunction);
        }
        this.currentGoals.removeAll(this.getCoveredGoals());
        for (Integer branchID : result.getTrace().getCoveredFalseBranches()) {
            TestFitnessFunction branch = this.branchCoverageFalseMap.get(branchID);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
        for (Integer branchID : result.getTrace().getCoveredTrueBranches()) {
            TestFitnessFunction branch = this.branchCoverageTrueMap.get(branchID);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
        for (String method : result.getTrace().getCoveredBranchlessMethods()) {
            TestFitnessFunction branch = this.branchlessMethodCoverageMap.get(method);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
    }

    protected void debugStructuralDependencies(TestChromosome c) {
        for (TestFitnessFunction fitnessFunction : this.getUncoveredGoals()) {
            double value = fitnessFunction.getFitness(c);
            if (!(value < 1.0) || this.currentGoals.contains(fitnessFunction) || this.getCoveredGoals().contains(fitnessFunction)) continue;
            logger.error("Branch {} has fitness {} but is not in the current goals", (Object)fitnessFunction.toString(), (Object)value);
        }
    }

    public BranchFitnessGraph getGraph() {
        return this.graph;
    }
}

