/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.structural;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.coverage.cbranch.CBranchTestFitness;
import org.evosuite.coverage.exception.ExceptionCoverageFactory;
import org.evosuite.coverage.exception.ExceptionCoverageHelper;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.coverage.exception.TryCatchCoverageTestFitness;
import org.evosuite.coverage.io.input.InputCoverageTestFitness;
import org.evosuite.coverage.io.output.OutputCoverageTestFitness;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.coverage.method.MethodCoverageTestFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageTestFitness;
import org.evosuite.coverage.mutation.StrongMutationTestFitness;
import org.evosuite.coverage.mutation.WeakMutationTestFitness;
import org.evosuite.coverage.statement.StatementCoverageTestFitness;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.mosa.structural.BranchFitnessGraph;
import org.evosuite.ga.metaheuristics.mosa.structural.StructuralGoalManager;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.setup.CallContext;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.callgraph.CallGraph;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiCriteriaManager
extends StructuralGoalManager
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MultiCriteriaManager.class);
    private static final long serialVersionUID = 8161137239404885564L;
    protected BranchFitnessGraph graph;
    protected Map<BranchCoverageTestFitness, Set<TestFitnessFunction>> dependencies;
    protected final Map<Integer, TestFitnessFunction> branchCoverageTrueMap = new LinkedHashMap<Integer, TestFitnessFunction>();
    protected final Map<Integer, TestFitnessFunction> branchCoverageFalseMap = new LinkedHashMap<Integer, TestFitnessFunction>();
    private final Map<String, TestFitnessFunction> branchlessMethodCoverageMap = new LinkedHashMap<String, TestFitnessFunction>();

    public MultiCriteriaManager(List<TestFitnessFunction> targets) {
        super(targets);
        this.graph = this.getControlDependencies4Branches(targets);
        block14: for (Properties.Criterion criterion : Properties.CRITERION) {
            switch (criterion) {
                case BRANCH: {
                    continue block14;
                }
                case EXCEPTION: {
                    continue block14;
                }
                case LINE: {
                    this.addDependencies4Line();
                    continue block14;
                }
                case STATEMENT: {
                    this.addDependencies4Statement();
                    continue block14;
                }
                case WEAKMUTATION: {
                    this.addDependencies4WeakMutation();
                    continue block14;
                }
                case STRONGMUTATION: {
                    this.addDependencies4StrongMutation();
                    continue block14;
                }
                case METHOD: {
                    this.addDependencies4Methods();
                    continue block14;
                }
                case INPUT: {
                    this.addDependencies4Input();
                    continue block14;
                }
                case OUTPUT: {
                    this.addDependencies4Output();
                    continue block14;
                }
                case TRYCATCH: {
                    this.addDependencies4TryCatch();
                    continue block14;
                }
                case METHODNOEXCEPTION: {
                    this.addDependencies4MethodsNoException();
                    continue block14;
                }
                case CBRANCH: {
                    this.addDependencies4CBranch();
                    continue block14;
                }
                default: {
                    LoggingUtils.getEvoLogger().error("The criterion {} is not currently supported in DynaMOSA", (Object)criterion.name());
                }
            }
        }
        this.currentGoals.addAll(this.graph.getRootBranches());
    }

    private void addDependencies4TryCatch() {
        logger.debug("Added dependencies for Try-Catch");
        for (FitnessFunction fitnessFunction : this.getUncoveredGoals()) {
            if (!(fitnessFunction instanceof TryCatchCoverageTestFitness)) continue;
            TryCatchCoverageTestFitness stmt = (TryCatchCoverageTestFitness)fitnessFunction;
            BranchCoverageTestFitness branch = new BranchCoverageTestFitness(stmt.getBranchGoal());
            this.dependencies.get(branch).add(stmt);
        }
    }

    private void initializeMaps(Set<TestFitnessFunction> set) {
        for (TestFitnessFunction ff : set) {
            BranchCoverageTestFitness goal = (BranchCoverageTestFitness)ff;
            if (goal.getBranch() != null && goal.getBranch().isInstrumented()) continue;
            if (goal.getBranch() == null) {
                this.branchlessMethodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), ff);
                continue;
            }
            if (goal.getBranchExpressionValue()) {
                this.branchCoverageTrueMap.put(goal.getBranch().getActualBranchId(), ff);
                continue;
            }
            this.branchCoverageFalseMap.put(goal.getBranch().getActualBranchId(), ff);
        }
    }

    private void addDependencies4Output() {
        logger.debug("Added dependencies for Output");
        for (TestFitnessFunction ff : this.getUncoveredGoals()) {
            if (!(ff instanceof OutputCoverageTestFitness)) continue;
            OutputCoverageTestFitness output = (OutputCoverageTestFitness)ff;
            InstrumentingClassLoader loader = TestGenerationContext.getInstance().getClassLoaderForSUT();
            BytecodeInstructionPool pool = BytecodeInstructionPool.getInstance(loader);
            if (pool.getInstructionsIn(output.getClassName(), output.getMethod()) == null) {
                this.currentGoals.add(ff);
                continue;
            }
            for (BytecodeInstruction instruction : pool.getInstructionsIn(output.getClassName(), output.getMethod())) {
                if (instruction.getBasicBlock() == null) continue;
                Set<ControlDependency> cds = instruction.getBasicBlock().getControlDependencies();
                if (cds.size() == 0) {
                    this.currentGoals.add(ff);
                    continue;
                }
                for (ControlDependency cd : cds) {
                    BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
                    this.dependencies.get(fitness).add(ff);
                }
            }
        }
    }

    private void addDependencies4Input() {
        logger.debug("Added dependencies for Input");
        for (TestFitnessFunction ff : this.getUncoveredGoals()) {
            if (!(ff instanceof InputCoverageTestFitness)) continue;
            InputCoverageTestFitness input = (InputCoverageTestFitness)ff;
            InstrumentingClassLoader loader = TestGenerationContext.getInstance().getClassLoaderForSUT();
            BytecodeInstructionPool pool = BytecodeInstructionPool.getInstance(loader);
            if (pool.getInstructionsIn(input.getClassName(), input.getMethod()) == null) {
                this.currentGoals.add(ff);
                continue;
            }
            for (BytecodeInstruction instruction : pool.getInstructionsIn(input.getClassName(), input.getMethod())) {
                if (instruction.getBasicBlock() == null) continue;
                Set<ControlDependency> cds = instruction.getBasicBlock().getControlDependencies();
                if (cds.size() == 0) {
                    this.currentGoals.add(ff);
                    continue;
                }
                for (ControlDependency cd : cds) {
                    BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
                    this.dependencies.get(fitness).add(ff);
                }
            }
        }
    }

    private void addDependencies4Methods() {
        logger.debug("Added dependencies for Methods");
        for (BranchCoverageTestFitness branch : this.dependencies.keySet()) {
            MethodCoverageTestFitness method = new MethodCoverageTestFitness(branch.getClassName(), branch.getMethod());
            this.dependencies.get(branch).add(method);
        }
    }

    private void addDependencies4MethodsNoException() {
        logger.debug("Added dependencies for MethodsNoException");
        for (BranchCoverageTestFitness branch : this.dependencies.keySet()) {
            MethodNoExceptionCoverageTestFitness method = new MethodNoExceptionCoverageTestFitness(branch.getClassName(), branch.getMethod());
            this.dependencies.get(branch).add(method);
        }
    }

    private void addDependencies4CBranch() {
        logger.debug("Added dependencies for CBranch");
        CallGraph callGraph = DependencyAnalysis.getCallGraph();
        for (BranchCoverageTestFitness branch : this.dependencies.keySet()) {
            for (CallContext context : callGraph.getMethodEntryPoint(branch.getClassName(), branch.getMethod())) {
                CBranchTestFitness cBranch = new CBranchTestFitness(branch.getBranchGoal(), context);
                this.dependencies.get(branch).add(cBranch);
                logger.debug("Added context branch: " + cBranch.toString());
            }
        }
    }

    private void addDependencies4WeakMutation() {
        logger.debug("Added dependencies for Weak-Mutation");
        for (TestFitnessFunction ff : this.getUncoveredGoals()) {
            if (!(ff instanceof WeakMutationTestFitness)) continue;
            WeakMutationTestFitness mutation = (WeakMutationTestFitness)ff;
            Set<BranchCoverageGoal> goals = mutation.getMutation().getControlDependencies();
            if (goals.size() == 0) {
                this.currentGoals.add(ff);
                continue;
            }
            for (BranchCoverageGoal goal : goals) {
                BranchCoverageTestFitness fitness = new BranchCoverageTestFitness(goal);
                this.dependencies.get(fitness).add(ff);
            }
        }
    }

    private void addDependencies4StrongMutation() {
        logger.debug("Added dependencies for Strong-Mutation");
        for (TestFitnessFunction ff : this.getUncoveredGoals()) {
            if (!(ff instanceof StrongMutationTestFitness)) continue;
            StrongMutationTestFitness mutation = (StrongMutationTestFitness)ff;
            Set<BranchCoverageGoal> goals = mutation.getMutation().getControlDependencies();
            if (goals.size() == 0) {
                this.currentGoals.add(ff);
                continue;
            }
            for (BranchCoverageGoal goal : goals) {
                BranchCoverageTestFitness fitness = new BranchCoverageTestFitness(goal);
                this.dependencies.get(fitness).add(ff);
            }
        }
    }

    private void addDependencies4Line() {
        logger.debug("Added dependencies for Lines");
        for (TestFitnessFunction ff : this.getUncoveredGoals()) {
            if (!(ff instanceof LineCoverageTestFitness)) continue;
            LineCoverageTestFitness line = (LineCoverageTestFitness)ff;
            InstrumentingClassLoader loader = TestGenerationContext.getInstance().getClassLoaderForSUT();
            BytecodeInstructionPool pool = BytecodeInstructionPool.getInstance(loader);
            BytecodeInstruction instruction = pool.getFirstInstructionAtLineNumber(line.getClassName(), line.getMethod(), line.getLine());
            Set<ControlDependency> cds = instruction.getControlDependencies();
            if (cds.size() == 0) {
                this.currentGoals.add(ff);
                continue;
            }
            for (ControlDependency cd : cds) {
                BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
                this.dependencies.get(fitness).add(ff);
            }
        }
    }

    private void addDependencies4Statement() {
        logger.debug("Added dependencies for Statements");
        for (TestFitnessFunction ff : this.getUncoveredGoals()) {
            if (!(ff instanceof StatementCoverageTestFitness)) continue;
            StatementCoverageTestFitness stmt = (StatementCoverageTestFitness)ff;
            if (stmt.getBranchFitnesses().size() == 0) {
                this.currentGoals.add(ff);
                continue;
            }
            for (BranchCoverageTestFitness branch : stmt.getBranchFitnesses()) {
                this.dependencies.get(branch).add(stmt);
            }
        }
    }

    @Override
    public void calculateFitness(TestChromosome c, GeneticAlgorithm<TestChromosome> ga) {
        TestFitnessFunction branch;
        TestCase test = c.getTestCase();
        ExecutionResult result = TestCaseExecutor.runTest(test);
        c.setLastExecutionResult(result);
        c.setChanged(false);
        if (result.hasTimeout() || result.hasTestException() || result.getTrace().getCoveredLines().size() == 0) {
            this.currentGoals.forEach(f -> c.setFitness(f, Double.MAX_VALUE));
            return;
        }
        LinkedHashSet<TestFitnessFunction> visitedTargets = new LinkedHashSet<TestFitnessFunction>(this.getUncoveredGoals().size() * 2);
        LinkedList<TestFitnessFunction> targets = new LinkedList<TestFitnessFunction>(this.currentGoals);
        while (targets.size() > 0 && !ga.isFinished()) {
            TestFitnessFunction target = (TestFitnessFunction)targets.poll();
            int pastSize = visitedTargets.size();
            visitedTargets.add(target);
            if (pastSize == visitedTargets.size()) continue;
            double fitness = target.getFitness(c);
            if (fitness == 0.0) {
                this.updateCoveredGoals(target, c);
                if (!(target instanceof BranchCoverageTestFitness)) continue;
                for (TestFitnessFunction child : this.graph.getStructuralChildren(target)) {
                    targets.addLast(child);
                }
                for (TestFitnessFunction dependentTarget : this.dependencies.get(target)) {
                    targets.addLast(dependentTarget);
                }
                continue;
            }
            this.currentGoals.add(target);
        }
        this.currentGoals.removeAll(this.getCoveredGoals());
        ExecutionTrace trace = result.getTrace();
        Iterator<Object> pastSize = trace.getCoveredFalseBranches().iterator();
        while (pastSize.hasNext()) {
            int branchid = pastSize.next();
            branch = this.branchCoverageFalseMap.get(branchid);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
        pastSize = trace.getCoveredTrueBranches().iterator();
        while (pastSize.hasNext()) {
            int branchid = pastSize.next();
            branch = this.branchCoverageTrueMap.get(branchid);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
        for (String method : trace.getCoveredBranchlessMethods()) {
            branch = this.branchlessMethodCoverageMap.get(method);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.EXCEPTION)) {
            Set<ExceptionCoverageTestFitness> set = this.deriveCoveredExceptions(c);
            for (ExceptionCoverageTestFitness exp : set) {
                this.updateCoveredGoals(exp, c);
                if (ExceptionCoverageFactory.getGoals().containsKey(exp.getKey())) continue;
                ExceptionCoverageFactory.getGoals().put(exp.getKey(), exp);
            }
        }
    }

    public Set<ExceptionCoverageTestFitness> deriveCoveredExceptions(TestChromosome t) {
        LinkedHashSet<ExceptionCoverageTestFitness> covered_exceptions = new LinkedHashSet<ExceptionCoverageTestFitness>();
        ExecutionResult result = t.getLastExecutionResult();
        if (result.calledReflection()) {
            return covered_exceptions;
        }
        for (Integer i : result.getPositionsWhereExceptionsWereThrown()) {
            if (ExceptionCoverageHelper.shouldSkip(result, i)) continue;
            Class<?> exceptionClass = ExceptionCoverageHelper.getExceptionClass(result, i);
            String methodIdentifier = ExceptionCoverageHelper.getMethodIdentifier(result, i);
            boolean sutException = ExceptionCoverageHelper.isSutException(result, i);
            if (!sutException) continue;
            ExceptionCoverageTestFitness.ExceptionType type = ExceptionCoverageHelper.getType(result, i);
            ExceptionCoverageTestFitness goal = new ExceptionCoverageTestFitness(Properties.TARGET_CLASS, methodIdentifier, exceptionClass, type);
            covered_exceptions.add(goal);
        }
        return covered_exceptions;
    }

    public BranchFitnessGraph getControlDependencies4Branches(List<TestFitnessFunction> fitnessFunctions) {
        LinkedHashSet<TestFitnessFunction> setOfBranches = new LinkedHashSet<TestFitnessFunction>();
        this.dependencies = new LinkedHashMap<BranchCoverageTestFitness, Set<TestFitnessFunction>>();
        List<BranchCoverageTestFitness> branches = new BranchCoverageFactory().getCoverageGoals();
        for (BranchCoverageTestFitness branch : branches) {
            setOfBranches.add(branch);
            this.dependencies.put(branch, new LinkedHashSet());
        }
        this.initializeMaps(setOfBranches);
        return new BranchFitnessGraph(setOfBranches);
    }
}

