/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.structural;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;

public abstract class StructuralGoalManager
implements Serializable {
    private static final long serialVersionUID = -2577487057354286024L;
    protected Set<TestFitnessFunction> currentGoals;
    protected Archive archive;

    protected StructuralGoalManager(List<TestFitnessFunction> fitnessFunctions) {
        this.currentGoals = new HashSet<TestFitnessFunction>(fitnessFunctions.size());
        this.archive = Archive.getArchiveInstance();
        this.archive.addTargets(fitnessFunctions);
    }

    public abstract void calculateFitness(TestChromosome var1, GeneticAlgorithm<TestChromosome> var2);

    public Set<TestFitnessFunction> getUncoveredGoals() {
        return this.archive.getUncoveredTargets();
    }

    public Set<TestFitnessFunction> getCurrentGoals() {
        return this.currentGoals;
    }

    public Set<TestFitnessFunction> getCoveredGoals() {
        return this.archive.getCoveredTargets();
    }

    protected boolean isAlreadyCovered(TestFitnessFunction target) {
        return this.archive.getCoveredTargets().contains(target);
    }

    protected void updateCoveredGoals(TestFitnessFunction f, TestChromosome tc) {
        tc.getTestCase().getCoveredGoals().add(f);
        this.archive.updateArchive(f, tc, tc.getFitness(f));
    }
}

