/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mulambda;

import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuLambda<T extends Chromosome<T>>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 2738004761503761376L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractMuLambda.class);
    protected final int mu;
    protected final int lambda;

    public AbstractMuLambda(ChromosomeFactory<T> factory, int mu, int lambda) {
        super(factory);
        this.mu = mu;
        this.lambda = lambda;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateRandomPopulation(this.mu);
        assert (this.population.size() == this.mu);
        this.calculateFitnessAndSortPopulation();
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        if (Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER > 0 || Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION) {
            this.disableFirstSecondaryCriterion();
        }
        int starvationCounter = 0;
        double bestFitness = Double.MAX_VALUE;
        double lastBestFitness = Double.MAX_VALUE;
        if (this.getFitnessFunction().isMaximizationFunction()) {
            bestFitness = 0.0;
            lastBestFitness = 0.0;
        }
        while (!this.isFinished()) {
            logger.debug("Current population: " + this.getAge() + "/" + Properties.SEARCH_BUDGET);
            logger.info("Best fitness: " + ((Chromosome)this.getBestIndividual()).getFitness());
            this.evolve();
            this.applyLocalSearch();
            double newFitness = ((Chromosome)this.getBestIndividual()).getFitness();
            if (this.getFitnessFunction().isMaximizationFunction() ? !$assertionsDisabled && !(newFitness >= bestFitness) : !$assertionsDisabled && !(newFitness <= bestFitness)) {
                throw new AssertionError((Object)("best fitness was: " + bestFitness + ", now best fitness is " + newFitness));
            }
            bestFitness = newFitness;
            if (Double.compare(bestFitness, lastBestFitness) == 0) {
                ++starvationCounter;
            } else {
                logger.info("reset starvationCounter after " + starvationCounter + " iterations");
                starvationCounter = 0;
                lastBestFitness = bestFitness;
            }
            this.updateFitnessFunctionsAndValues();
            this.notifyIteration();
        }
        TimeController.execute(this::updateBestIndividualFromArchive, "update from archive", 5000L);
        this.notifySearchFinished();
    }
}

