/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.crossover;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.utils.Randomness;

public class SinglePointRelativeCrossOver<T extends Chromosome<T>>
extends CrossOverFunction<T> {
    private static final long serialVersionUID = -5320348525459502224L;

    @Override
    public void crossOver(T parent1, T parent2) throws ConstructionFailedException {
        if (((Chromosome)parent1).size() < 2 || ((Chromosome)parent2).size() < 2) {
            return;
        }
        Object t1 = ((Chromosome)parent1).clone();
        Object t2 = ((Chromosome)parent2).clone();
        float splitPoint = Randomness.nextFloat();
        int pos1 = (int)Math.floor((float)(((Chromosome)t1).size() - 1) * splitPoint) + 1;
        int pos2 = (int)Math.floor((float)(((Chromosome)t2).size() - 1) * splitPoint) + 1;
        ((Chromosome)parent1).crossOver((Object)t2, pos1, pos2);
        ((Chromosome)parent2).crossOver((Object)t1, pos2, pos1);
    }
}

