/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.mutation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.evosuite.ga.operators.mutation.MutationHistoryEntry;

public class MutationHistory<T extends MutationHistoryEntry>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -8543180637106924913L;
    private final List<T> mutations = new ArrayList<T>();

    public void clear() {
        this.mutations.clear();
    }

    public void addMutationEntry(T entry) {
        this.mutations.add(entry);
    }

    public List<T> getMutations() {
        return Collections.unmodifiableList(this.mutations);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mutations.iterator();
    }

    public int size() {
        return this.mutations.size();
    }

    public boolean isEmpty() {
        return this.mutations.isEmpty();
    }

    public void set(MutationHistory<T> other) {
        this.mutations.addAll(other.getMutations());
    }

    public String toString() {
        return this.mutations.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

