/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.ranking;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.DominanceComparator;
import org.evosuite.ga.comparators.PreferenceSortingComparator;
import org.evosuite.ga.operators.ranking.RankingFunction;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankBasedPreferenceSorting<T extends Chromosome<T>>
implements RankingFunction<T> {
    private static final long serialVersionUID = -6636175563989586394L;
    private static final Logger logger = LoggerFactory.getLogger(RankBasedPreferenceSorting.class);
    private List<List<T>> fronts = null;

    @Override
    public void computeRankingAssignment(List<T> solutions, Set<? extends FitnessFunction<T>> uncovered_goals) {
        if (solutions.isEmpty()) {
            logger.debug("solution is empty");
            return;
        }
        this.fronts = new ArrayList<List<T>>(solutions.size());
        List<T> zero_front = this.getZeroFront(solutions, uncovered_goals);
        this.fronts.add(zero_front);
        int frontIndex = 1;
        if (zero_front.size() < Properties.POPULATION) {
            int rankedSolutions = zero_front.size();
            DominanceComparator comparator = new DominanceComparator(uncovered_goals);
            ArrayList<T> remaining = new ArrayList<T>(solutions.size());
            remaining.addAll(solutions);
            remaining.removeAll(zero_front);
            while (rankedSolutions < Properties.POPULATION && remaining.size() > 0) {
                List new_front = this.getNonDominatedSolutions(remaining, comparator, frontIndex);
                this.fronts.add(new_front);
                remaining.removeAll(new_front);
                rankedSolutions += new_front.size();
                ++frontIndex;
            }
        } else {
            ArrayList<T> remaining = new ArrayList<T>(solutions.size());
            remaining.addAll(solutions);
            remaining.removeAll(zero_front);
            for (Chromosome t : remaining) {
                t.setRank(frontIndex);
            }
            this.fronts.add(remaining);
        }
    }

    private List<T> getZeroFront(List<T> solutionSet, Set<? extends FitnessFunction<T>> uncovered_goals) {
        LinkedHashSet<Chromosome> zero_front = new LinkedHashSet<Chromosome>(solutionSet.size());
        for (FitnessFunction<T> f : uncovered_goals) {
            PreferenceSortingComparator<Chromosome> comp = new PreferenceSortingComparator<Chromosome>(f);
            Chromosome best = null;
            for (Chromosome test : solutionSet) {
                int flag = comp.compare(test, best);
                if (flag >= 0 && (flag != 0 || !Randomness.nextBoolean())) continue;
                best = test;
            }
            assert (best != null);
            best.setRank(0);
            zero_front.add(best);
        }
        return new ArrayList(zero_front);
    }

    private List<T> getNonDominatedSolutions(List<T> solutions, DominanceComparator<T> comparator, int frontIndex) {
        ArrayList<Chromosome> front = new ArrayList<Chromosome>(solutions.size());
        for (Chromosome p : solutions) {
            boolean isDominated = false;
            ArrayList<Chromosome> dominatedSolutions = new ArrayList<Chromosome>(solutions.size());
            for (Chromosome best : front) {
                int flag = comparator.compare(p, best);
                if (flag < 0) {
                    dominatedSolutions.add(best);
                }
                if (flag <= 0) continue;
                isDominated = true;
                break;
            }
            if (isDominated) continue;
            p.setRank(frontIndex);
            front.add(p);
            front.removeAll(dominatedSolutions);
        }
        return front;
    }

    @Override
    public List<T> getSubfront(int rank) {
        if (this.fronts == null || rank >= this.fronts.size()) {
            return new ArrayList();
        }
        return this.fronts.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.fronts.size();
    }
}

