/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.selection;

import java.util.List;
import java.util.stream.DoubleStream;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.utils.Randomness;

public class FitnessProportionateSelection<T extends Chromosome<T>>
extends SelectionFunction<T> {
    private static final long serialVersionUID = 5206421079815585026L;
    private double sumValue = 0.0;

    public FitnessProportionateSelection() {
    }

    public FitnessProportionateSelection(FitnessProportionateSelection<?> other) {
        this.sumValue = other.sumValue;
    }

    @Override
    public int getIndex(List<T> population) {
        if (this.sumValue == 0.0) {
            return Randomness.nextInt(population.size());
        }
        double rnd = Randomness.nextDouble() * this.sumValue;
        for (int i = 0; i < population.size(); ++i) {
            double fit = ((Chromosome)population.get(i)).getFitness();
            if (!this.maximize) {
                fit = FitnessProportionateSelection.invert(fit);
            }
            if (fit >= rnd) {
                return i;
            }
            rnd -= fit;
        }
        logger.debug("ATTENTION: Possible issue in FitnessProportionateSelection");
        return Randomness.nextInt(population.size());
    }

    private void setSum(List<T> population) {
        DoubleStream fitnessValues = population.stream().mapToDouble(Chromosome::getFitness);
        if (!this.maximize) {
            fitnessValues = fitnessValues.map(FitnessProportionateSelection::invert);
        }
        this.sumValue = fitnessValues.sum();
    }

    private static double invert(double x) {
        return 1.0 / (x + 1.0);
    }

    @Override
    public List<T> select(List<T> population, int number) {
        this.setSum(population);
        return super.select(population, number);
    }
}

