/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.evosuite.ga.Chromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SelectionFunction<T extends Chromosome<T>>
implements Serializable {
    private static final long serialVersionUID = -2514933149542277609L;
    protected static final Logger logger = LoggerFactory.getLogger(SelectionFunction.class);
    protected boolean maximize = true;

    public abstract int getIndex(List<T> var1);

    public T select(List<T> population) {
        return (T)((Chromosome)this.select(population, 1).get(0));
    }

    public List<T> select(List<T> population, int number) {
        return Stream.generate(() -> this.getIndex(population)).limit(number).map(population::get).collect(Collectors.toCollection(ArrayList::new));
    }

    public void setMaximize(boolean max) {
        this.maximize = max;
    }

    public boolean isMaximize() {
        return this.maximize;
    }
}

