/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.selection;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.comparators.RankAndCrowdingDistanceComparator;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.utils.Randomness;

public class TournamentSelectionRankAndCrowdingDistanceComparator<T extends Chromosome<T>>
extends SelectionFunction<T> {
    private static final long serialVersionUID = 781669365989544671L;
    private final RankAndCrowdingDistanceComparator<T> comparator;

    public TournamentSelectionRankAndCrowdingDistanceComparator() {
        this.comparator = new RankAndCrowdingDistanceComparator(this.maximize);
    }

    public TournamentSelectionRankAndCrowdingDistanceComparator(boolean isToMaximize) {
        this.comparator = new RankAndCrowdingDistanceComparator(isToMaximize);
    }

    public TournamentSelectionRankAndCrowdingDistanceComparator(TournamentSelectionRankAndCrowdingDistanceComparator<?> other) {
        this.comparator = new RankAndCrowdingDistanceComparator(other.comparator);
    }

    @Override
    public int getIndex(List<T> population) {
        int new_num;
        int winner = new_num = Randomness.nextInt(population.size());
        for (int round = 0; round < Properties.TOURNAMENT_SIZE - 1; ++round) {
            Chromosome selected;
            int flag;
            new_num = Randomness.nextInt(population.size());
            if (new_num == winner) {
                new_num = (new_num + 1) % population.size();
            }
            if ((flag = this.comparator.compare(selected = (Chromosome)population.get(new_num), (Chromosome)population.get(winner))) >= 0) continue;
            winner = new_num;
        }
        return winner;
    }

    @Override
    public T select(List<T> population) {
        return (T)((Chromosome)population.get(this.getIndex(population)));
    }

    @Override
    public void setMaximize(boolean max) {
        super.setMaximize(max);
        this.comparator.setMaximize(max);
    }
}

