/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;

public class MaxGenerationStoppingCondition<T extends Chromosome<T>>
extends StoppingConditionImpl<T> {
    private static final long serialVersionUID = 251196904115160351L;
    protected long maxIterations;
    protected long currentIteration;

    public MaxGenerationStoppingCondition() {
        this.maxIterations = Properties.SEARCH_BUDGET;
        this.currentIteration = 0L;
    }

    public MaxGenerationStoppingCondition(MaxGenerationStoppingCondition<?> that) {
        this.maxIterations = that.maxIterations;
        this.currentIteration = that.currentIteration;
    }

    @Override
    public MaxGenerationStoppingCondition<T> clone() {
        return new MaxGenerationStoppingCondition<T>(this);
    }

    public void setMaxIterations(int max) {
        this.maxIterations = max;
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
        ++this.currentIteration;
    }

    @Override
    public boolean isFinished() {
        return this.currentIteration >= this.maxIterations;
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
        this.currentIteration = 0L;
    }

    @Override
    public void reset() {
        this.currentIteration = 0L;
    }

    @Override
    public void setLimit(long limit) {
        this.maxIterations = limit;
    }

    @Override
    public long getLimit() {
        return this.maxIterations;
    }

    @Override
    public long getCurrentValue() {
        return this.currentIteration;
    }

    @Override
    public void forceCurrentValue(long value) {
        this.currentIteration = value;
    }
}

