/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import java.io.IOException;
import java.net.ServerSocket;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketStoppingCondition<T extends Chromosome<T>>
implements StoppingCondition<T> {
    private static final long serialVersionUID = -8260473153410290373L;
    private static SocketStoppingCondition<?> instance = null;
    private volatile boolean interrupted = false;
    private static final Logger logger = LoggerFactory.getLogger(SocketStoppingCondition.class);

    private SocketStoppingCondition() {
    }

    public static <T extends Chromosome<T>> SocketStoppingCondition<T> getInstance() {
        if (instance == null) {
            instance = new SocketStoppingCondition<T>();
        }
        return instance;
    }

    @Override
    public StoppingCondition<T> clone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("cannot clone singleton");
    }

    public void accept() {
        Thread t = new Thread(() -> {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(Properties.STOPPING_PORT);
                serverSocket.accept();
                LoggingUtils.getEvoLogger().info("* Stopping request received");
                this.interrupted = true;
            }
            catch (IOException e) {
                LoggingUtils.getEvoLogger().warn("Failed to create socket on port " + Properties.STOPPING_PORT);
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        logger.info("Error while closing socket: " + e);
                    }
                }
            }
        });
        t.start();
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void fitnessEvaluation(T individual) {
    }

    @Override
    public void modification(T individual) {
    }

    @Override
    public void forceCurrentValue(long value) {
    }

    @Override
    public long getCurrentValue() {
        return 0L;
    }

    @Override
    public long getLimit() {
        return 0L;
    }

    @Override
    public boolean isFinished() {
        return this.interrupted;
    }

    @Override
    public void reset() {
        this.interrupted = false;
    }

    @Override
    public void setLimit(long limit) {
    }
}

