/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;

public class ZeroFitnessStoppingCondition<T extends Chromosome<T>>
extends StoppingConditionImpl<T> {
    private static final long serialVersionUID = -6925872054053635256L;
    private double lastFitness;

    public ZeroFitnessStoppingCondition() {
        this.lastFitness = Double.MAX_VALUE;
    }

    public ZeroFitnessStoppingCondition(ZeroFitnessStoppingCondition<?> that) {
        this.lastFitness = that.lastFitness;
    }

    @Override
    public ZeroFitnessStoppingCondition<T> clone() {
        return new ZeroFitnessStoppingCondition<T>(this);
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
        this.lastFitness = Math.min(this.lastFitness, ((Chromosome)algorithm.getBestIndividual()).getFitness());
    }

    @Override
    public boolean isFinished() {
        return this.lastFitness <= 0.0;
    }

    @Override
    public void reset() {
        this.lastFitness = Double.MAX_VALUE;
    }

    @Override
    public void setLimit(long limit) {
    }

    @Override
    public long getLimit() {
        return 0L;
    }

    @Override
    public long getCurrentValue() {
        return (long)(this.lastFitness + 0.5);
    }

    public void setFinished() {
        this.lastFitness = 0.0;
    }

    @Override
    public void forceCurrentValue(long value) {
    }
}

