/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.graphs.ccfg.ClassControlFlowGraph;
import org.evosuite.graphs.ccg.ClassCallGraph;
import org.evosuite.graphs.cdg.ControlDependenceGraph;
import org.evosuite.graphs.cfg.ActualControlFlowGraph;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.setup.DependencyAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPool {
    private static final Logger logger = LoggerFactory.getLogger(GraphPool.class);
    private static Map<ClassLoader, GraphPool> instanceMap = new HashMap<ClassLoader, GraphPool>();
    private final ClassLoader classLoader;
    private final Map<String, Map<String, RawControlFlowGraph>> rawCFGs = new HashMap<String, Map<String, RawControlFlowGraph>>();
    private final Map<String, Map<String, ActualControlFlowGraph>> actualCFGs = new HashMap<String, Map<String, ActualControlFlowGraph>>();
    private final Map<String, Map<String, ControlDependenceGraph>> controlDependencies = new HashMap<String, Map<String, ControlDependenceGraph>>();
    private final Map<String, ClassControlFlowGraph> ccfgs = new HashMap<String, ClassControlFlowGraph>();

    private GraphPool(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static GraphPool getInstance(ClassLoader classLoader) {
        if (!instanceMap.containsKey(classLoader)) {
            instanceMap.put(classLoader, new GraphPool(classLoader));
        }
        return instanceMap.get(classLoader);
    }

    public RawControlFlowGraph getRawCFG(String className, String methodName) {
        if (this.rawCFGs.get(className) == null) {
            logger.warn("Class unknown: " + className);
            logger.warn(this.rawCFGs.keySet().toString());
            return null;
        }
        return this.rawCFGs.get(className).get(methodName);
    }

    public Map<String, RawControlFlowGraph> getRawCFGs(String className) {
        if (this.rawCFGs.get(className) == null) {
            logger.warn("Class unknown: " + className);
            logger.warn(this.rawCFGs.keySet().toString());
            return null;
        }
        return this.rawCFGs.get(className);
    }

    public ActualControlFlowGraph getActualCFG(String className, String methodName) {
        if (this.actualCFGs.get(className) == null) {
            return null;
        }
        return this.actualCFGs.get(className).get(methodName);
    }

    public ControlDependenceGraph getCDG(String className, String methodName) {
        if (this.controlDependencies.get(className) == null) {
            return null;
        }
        return this.controlDependencies.get(className).get(methodName);
    }

    public void registerRawCFG(RawControlFlowGraph cfg) {
        String className = cfg.getClassName();
        String methodName = cfg.getMethodName();
        if (className == null || methodName == null) {
            throw new IllegalStateException("expect class and method name of CFGs to be set before entering the GraphPool");
        }
        if (!this.rawCFGs.containsKey(className)) {
            this.rawCFGs.put(className, new HashMap());
        }
        Map<String, RawControlFlowGraph> methods = this.rawCFGs.get(className);
        logger.debug("Added complete CFG for class " + className + " and method " + methodName);
        methods.put(methodName, cfg);
        if (Properties.WRITE_CFG) {
            cfg.toDot();
        }
    }

    public void registerActualCFG(ActualControlFlowGraph cfg) {
        String className = cfg.getClassName();
        String methodName = cfg.getMethodName();
        if (className == null || methodName == null) {
            throw new IllegalStateException("expect class and method name of CFGs to be set before entering the GraphPool");
        }
        if (!this.actualCFGs.containsKey(className)) {
            this.actualCFGs.put(className, new HashMap());
        }
        Map<String, ActualControlFlowGraph> methods = this.actualCFGs.get(className);
        logger.debug("Added CFG for class " + className + " and method " + methodName);
        cfg.finalise();
        methods.put(methodName, cfg);
        if (Properties.WRITE_CFG) {
            cfg.toDot();
        }
        if (DependencyAnalysis.shouldInstrument(cfg.getClassName(), cfg.getMethodName())) {
            this.createAndRegisterControlDependence(cfg);
        }
    }

    private void createAndRegisterControlDependence(ActualControlFlowGraph cfg) {
        ControlDependenceGraph cd = new ControlDependenceGraph(cfg);
        String className = cd.getClassName();
        String methodName = cd.getMethodName();
        if (className == null || methodName == null) {
            throw new IllegalStateException("expect class and method name of CFGs to be set before entering the GraphPool");
        }
        if (!this.controlDependencies.containsKey(className)) {
            this.controlDependencies.put(className, new HashMap());
        }
        Map<String, ControlDependenceGraph> cds = this.controlDependencies.get(className);
        cds.put(methodName, cd);
        if (Properties.WRITE_CFG) {
            cd.toDot();
        }
    }

    public ClassControlFlowGraph getCCFG(String className) {
        if (!this.ccfgs.containsKey(className)) {
            this.ccfgs.put(className, this.computeCCFG(className));
        }
        return this.ccfgs.get(className);
    }

    public boolean canMakeCCFGForClass(String className) {
        return this.rawCFGs.containsKey(className);
    }

    private ClassControlFlowGraph computeCCFG(String className) {
        if (this.rawCFGs.get(className) == null) {
            throw new IllegalArgumentException("can't compute CCFG, don't know CFGs for class " + className);
        }
        ClassCallGraph ccg = new ClassCallGraph(this.classLoader, className);
        if (Properties.WRITE_CFG) {
            ccg.toDot();
        }
        ClassControlFlowGraph ccfg = new ClassControlFlowGraph(ccg);
        if (Properties.WRITE_CFG) {
            ccfg.toDot();
        }
        return ccfg;
    }

    public void clear() {
        this.rawCFGs.clear();
        this.actualCFGs.clear();
        this.controlDependencies.clear();
    }

    public void clear(String className) {
        this.rawCFGs.remove(className);
        this.actualCFGs.remove(className);
        this.controlDependencies.remove(className);
    }

    public void clear(String className, String methodName) {
        if (this.rawCFGs.containsKey(className)) {
            this.rawCFGs.get(className).remove(methodName);
        }
        if (this.actualCFGs.containsKey(className)) {
            this.actualCFGs.get(className).remove(methodName);
        }
        if (this.controlDependencies.containsKey(className)) {
            this.controlDependencies.get(className).remove(methodName);
        }
    }

    public static void clearAll(String className) {
        instanceMap.values().forEach(pool -> pool.clear(className));
    }

    public static void clearAll(String className, String methodName) {
        instanceMap.values().forEach(pool -> pool.clear(className, methodName));
    }

    public static void clearAll() {
        instanceMap.clear();
    }
}

