/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cdg;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.evosuite.graphs.EvoSuiteGraph;
import org.evosuite.graphs.cdg.DominatorNode;
import org.evosuite.graphs.cfg.ControlFlowGraph;
import org.jgrapht.graph.DefaultEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DominatorTree<V>
extends EvoSuiteGraph<DominatorNode<V>, DefaultEdge> {
    private static final Logger logger = LoggerFactory.getLogger(DominatorTree.class);
    private int nodeCount = 0;
    private final ControlFlowGraph<V> cfg;
    private final Map<V, DominatorNode<V>> dominatorNodesMap = new LinkedHashMap<V, DominatorNode<V>>();
    private final Map<Integer, DominatorNode<V>> dominatorIDMap = new LinkedHashMap<Integer, DominatorNode<V>>();
    private final Map<V, Set<V>> dominatingFrontiers = new LinkedHashMap<V, Set<V>>();

    public DominatorTree(ControlFlowGraph<V> cfg) {
        super(DefaultEdge.class);
        logger.debug("Computing DominatorTree for " + cfg.getName());
        this.cfg = cfg;
        this.createDominatorNodes();
        V root = cfg.determineEntryPoint();
        logger.debug("determined root: " + root);
        DominatorNode<V> rootNode = this.getDominatorNodeFor(root);
        this.depthFirstAnalyze(rootNode);
        this.computeSemiDominators();
        this.computeImmediateDominators(rootNode);
        this.createDominatorTree();
        this.computeDominatorFrontiers(rootNode);
    }

    private void createDominatorTree() {
        this.addVertices(this.dominatorIDMap.values());
        logger.debug("DTNodes: " + this.vertexCount());
        for (DominatorNode v : this.vertexSet()) {
            if (v.isRootNode()) continue;
            if (this.addEdge(v.immediateDominator, v) == null) {
                throw new IllegalStateException("internal error while building dominator tree edges");
            }
            logger.debug("added DTEdge from " + v.immediateDominator.n + " to " + v.n);
        }
        logger.debug("DTEdges: " + this.edgeCount());
        if (this.isEmpty()) {
            throw new IllegalStateException("expect dominator trees to not be empty");
        }
        if (!this.isConnected()) {
            throw new IllegalStateException("dominator tree expected to be connected");
        }
    }

    private void computeDominatorFrontiers(DominatorNode<V> currentNode) {
        for (DominatorNode<V> child : this.getChildren(currentNode)) {
            this.computeDominatorFrontiers(child);
        }
        logger.debug("computing dominatingFrontier for: " + currentNode.toString());
        Set<V> dominatingFrontier = this.dominatingFrontiers.get(currentNode);
        if (dominatingFrontier == null) {
            dominatingFrontier = new HashSet<V>();
        }
        for (Object v : this.cfg.getChildren(currentNode.node)) {
            DominatorNode y = this.getDominatorNodeFor(v);
            if (y.immediateDominator.n == currentNode.n) continue;
            logger.debug("  LOCAL adding to DFs: " + y.node);
            dominatingFrontier.add(y.node);
        }
        for (DominatorNode dominatorNode : this.getChildren(currentNode)) {
            for (V y : this.dominatingFrontiers.get(dominatorNode.node)) {
                if (this.getDominatorNodeFor(y).immediateDominator.n == currentNode.n) continue;
                logger.debug("  UP adding to DFs: " + y);
                dominatingFrontier.add(y);
            }
        }
        this.dominatingFrontiers.put((Set<V>)currentNode.node, (Set<Set<V>>)dominatingFrontier);
    }

    public V getImmediateDominator(V v) {
        if (v == null) {
            throw new IllegalArgumentException("null given");
        }
        DominatorNode<V> domNode = this.dominatorNodesMap.get(v);
        if (domNode == null) {
            throw new IllegalStateException("unknown vertice given");
        }
        if (domNode.immediateDominator == null) {
            if (domNode.n != 1) {
                throw new IllegalStateException("expect known node without iDom to be root of CFG");
            }
            return null;
        }
        return domNode.immediateDominator.node;
    }

    public Set<V> getDominatingFrontiers(V v) {
        if (v == null) {
            throw new IllegalStateException("null given");
        }
        return this.dominatingFrontiers.get(v);
    }

    private void createDominatorNodes() {
        for (Object v : this.cfg.vertexSet()) {
            this.dominatorNodesMap.put(v, new DominatorNode(v));
        }
    }

    private void depthFirstAnalyze(DominatorNode<V> currentNode) {
        this.initialize(currentNode);
        for (Object w : this.cfg.getChildren(currentNode.node)) {
            DominatorNode wNode = this.getDominatorNodeFor(w);
            if (wNode.semiDominator != null) continue;
            wNode.parent = currentNode;
            this.depthFirstAnalyze(wNode);
        }
    }

    private void initialize(DominatorNode<V> currentNode) {
        ++this.nodeCount;
        currentNode.n = this.nodeCount;
        currentNode.semiDominator = currentNode;
        logger.debug("created " + currentNode.toString() + " for " + currentNode.node.toString());
        this.dominatorIDMap.put(this.nodeCount, currentNode);
    }

    private void computeSemiDominators() {
        for (int i = this.nodeCount; i >= 2; --i) {
            DominatorNode w = this.getDominatorNodeById(i);
            for (Object current : this.cfg.getParents(w.node)) {
                DominatorNode v = this.getDominatorNodeFor(current);
                DominatorNode u = v.eval();
                if (u.semiDominator.n >= w.semiDominator.n) continue;
                w.semiDominator = u.semiDominator;
            }
            w.semiDominator.bucket.add(w);
            w.link(w.parent);
            while (!w.parent.bucket.isEmpty()) {
                DominatorNode v = w.parent.getFromBucket();
                if (!w.parent.bucket.remove(v)) {
                    throw new IllegalStateException("internal error");
                }
                DominatorNode u = v.eval();
                v.immediateDominator = u.semiDominator.n < v.semiDominator.n ? u : w.parent;
            }
        }
    }

    private void computeImmediateDominators(DominatorNode<V> rootNode) {
        for (int i = 2; i <= this.nodeCount; ++i) {
            DominatorNode<V> w = this.getDominatorNodeById(i);
            if (w.immediateDominator == w.semiDominator) continue;
            w.immediateDominator = w.immediateDominator.immediateDominator;
        }
        rootNode.immediateDominator = null;
    }

    private DominatorNode<V> getDominatorNodeById(int id) {
        DominatorNode<V> r = this.dominatorIDMap.get(id);
        if (r == null) {
            throw new IllegalArgumentException("id unknown to this tree");
        }
        return r;
    }

    private DominatorNode<V> getDominatorNodeFor(V v) {
        DominatorNode<V> r = this.dominatorNodesMap.get(v);
        if (r == null) {
            throw new IllegalStateException("expect dominatorNodesMap to contain domNodes for all Vs");
        }
        return r;
    }

    @Override
    public String getName() {
        return "DominatorTree" + this.graphId;
    }
}

