/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.util.List;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.ActualControlFlowGraph;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.CFGFrame;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFGGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CFGGenerator.class);
    private RawControlFlowGraph rawGraph;
    private boolean nodeRegistered = false;
    private MethodNode currentMethod;
    private String className;
    private String methodName;
    private final ClassLoader classLoader;

    public CFGGenerator(ClassLoader classLoader, String className, String methodName, MethodNode node) {
        this.classLoader = classLoader;
        this.registerMethodNode(node, className, methodName);
    }

    public void registerCFGs() {
        int removed = this.getRawGraph().removeIsolatedNodes();
        if (removed > 0) {
            logger.info("removed isolated nodes: " + removed + " in " + this.methodName);
        }
        GraphPool.getInstance(this.classLoader).registerRawCFG(this.getRawGraph());
        GraphPool.getInstance(this.classLoader).registerActualCFG(this.computeActualCFG());
    }

    private void registerMethodNode(MethodNode currentMethod, String className, String methodName) {
        if (this.nodeRegistered) {
            throw new IllegalStateException("registerMethodNode must not be called more than once for each instance of CFGGenerator");
        }
        if (currentMethod == null || methodName == null || className == null) {
            throw new IllegalArgumentException("null given");
        }
        this.currentMethod = currentMethod;
        this.className = className;
        this.methodName = methodName;
        this.rawGraph = new RawControlFlowGraph(this.classLoader, className, methodName, currentMethod.access);
        List<BytecodeInstruction> instructionsInMethod = BytecodeInstructionPool.getInstance(this.classLoader).registerMethodNode(currentMethod, className, methodName);
        int count = 0;
        for (BytecodeInstruction ins : instructionsInMethod) {
            if (ins.isLabel() && ++count >= instructionsInMethod.size()) continue;
            this.rawGraph.addVertex(ins);
        }
        this.nodeRegistered = true;
    }

    public void registerControlFlowEdge(int src, int dst, Frame[] frames, boolean isExceptionEdge) {
        if (!this.nodeRegistered) {
            throw new IllegalStateException("CFGGenrator.registerControlFlowEdge() cannot be called unless registerMethodNode() was called first");
        }
        if (frames == null) {
            throw new IllegalArgumentException("null given");
        }
        CFGFrame srcFrame = (CFGFrame)frames[src];
        Frame dstFrame = frames[dst];
        if (srcFrame == null) {
            throw new IllegalArgumentException("expect given frames to know srcFrame for " + src);
        }
        if (dstFrame == null) {
            return;
        }
        srcFrame.successors.put(dst, (CFGFrame)dstFrame);
        AbstractInsnNode srcNode = this.currentMethod.instructions.get(src);
        AbstractInsnNode dstNode = this.currentMethod.instructions.get(dst);
        BytecodeInstruction srcInstruction = BytecodeInstructionPool.getInstance(this.classLoader).getInstruction(this.className, this.methodName, src, srcNode);
        BytecodeInstruction dstInstruction = BytecodeInstructionPool.getInstance(this.classLoader).getInstruction(this.className, this.methodName, dst, dstNode);
        srcInstruction.setCFGFrame(srcFrame);
        if (dstInstruction == null) {
            throw new IllegalStateException("expect BytecodeInstructionPool to know the instructions in the method of this edge");
        }
        if (null == this.rawGraph.addEdge(srcInstruction, dstInstruction, isExceptionEdge)) {
            logger.error("internal error while adding edge");
        }
    }

    public ActualControlFlowGraph computeActualCFG() {
        BytecodeInstructionPool.getInstance(this.classLoader).logInstructionsIn(this.className, this.methodName);
        ActualControlFlowGraph cfg = new ActualControlFlowGraph(this.rawGraph);
        return cfg;
    }

    protected RawControlFlowGraph getRawGraph() {
        return this.rawGraph;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

