/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.evosuite.instrumentation.ExceptionTransformationClassAdapter;
import org.evosuite.runtime.instrumentation.AnnotatedLabel;
import org.evosuite.shaded.org.objectweb.asm.Label;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.commons.GeneratorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionTransformationMethodAdapter
extends GeneratorAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ExceptionTransformationMethodAdapter.class);
    private final String className;
    private final String methodName;
    private final MethodVisitor next;
    private final List<TryCatchBlock> tryCatchBlocks = new LinkedList<TryCatchBlock>();
    private final List<TryCatchBlock> instrumentedTryCatchBlocks = new LinkedList<TryCatchBlock>();

    public ExceptionTransformationMethodAdapter(MethodVisitor mv, String className, String methodName, int access, String desc) {
        super(589824, mv, access, methodName, desc);
        this.className = className;
        this.methodName = methodName;
        this.next = mv;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!ExceptionTransformationClassAdapter.methodExceptionMap.containsKey(owner) || !ExceptionTransformationClassAdapter.methodExceptionMap.get(owner).containsKey(name + desc)) {
            logger.debug("Method {} does not throw exceptions", (Object)name);
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Set<Type> declaredExceptions = ExceptionTransformationClassAdapter.methodExceptionMap.get(owner).get(name + desc);
        if (declaredExceptions.isEmpty()) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        int exceptionInstanceVar = this.newLocal(Type.getType(Throwable.class));
        this.push((String)null);
        this.storeLocal(exceptionInstanceVar);
        Label start = this.newLabel();
        Label end = this.newLabel();
        Label catchLabel = this.newLabel();
        super.visitTryCatchBlock(start, end, catchLabel, null);
        TryCatchBlock block = new TryCatchBlock(start, end, catchLabel, null);
        this.instrumentedTryCatchBlocks.add(block);
        this.mark(start);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.mark(end);
        Label afterCatch = this.newLabel();
        this.goTo(afterCatch);
        this.mark(catchLabel);
        this.storeLocal(exceptionInstanceVar);
        this.loadLocal(exceptionInstanceVar);
        Label noExceptionLabel = this.newLabel();
        for (Type exceptionType : declaredExceptions) {
            this.loadLocal(exceptionInstanceVar);
            this.instanceOf(exceptionType);
            Label noJump = this.newLabel();
            Label jump = this.newLabel();
            this.tagBranch();
            this.visitJumpInsn(154, jump);
            this.visitJumpInsn(167, noJump);
            this.tagBranchExit();
            this.mark(jump);
            this.loadLocal(exceptionInstanceVar);
            this.checkCast(exceptionType);
            this.throwException();
            this.visitLabel(noJump);
        }
        this.tagBranch();
        Type runtimeExceptionType = Type.getType(RuntimeException.class);
        this.loadLocal(exceptionInstanceVar);
        this.checkCast(runtimeExceptionType);
        this.throwException();
        this.tagBranchExit();
        this.mark(afterCatch);
        this.loadLocal(exceptionInstanceVar);
        AnnotatedLabel startTag = new AnnotatedLabel(false, true);
        startTag.setIgnoreFalse(true);
        super.visitLabel(startTag);
        this.ifNull(noExceptionLabel);
        AnnotatedLabel endTag = new AnnotatedLabel(false, false);
        startTag.setIgnoreFalse(true);
        super.visitLabel(endTag);
        this.mark(noExceptionLabel);
    }

    @Override
    public void visitEnd() {
        for (TryCatchBlock tryCatchBlock : this.instrumentedTryCatchBlocks) {
            super.visitTryCatchBlock(tryCatchBlock.start, tryCatchBlock.end, tryCatchBlock.handler, tryCatchBlock.type);
        }
        for (TryCatchBlock tryCatchBlock : this.tryCatchBlocks) {
            super.visitTryCatchBlock(tryCatchBlock.start, tryCatchBlock.end, tryCatchBlock.handler, tryCatchBlock.type);
        }
        super.visitEnd();
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        TryCatchBlock block = new TryCatchBlock(start, end, handler, type);
        this.tryCatchBlocks.add(block);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 1, maxLocals);
    }

    public void tagBranch() {
        AnnotatedLabel dummyTag = new AnnotatedLabel(false, true);
        super.visitLabel(dummyTag);
    }

    public void tagBranchExit() {
        AnnotatedLabel dummyTag = new AnnotatedLabel(false, false);
        super.visitLabel(dummyTag);
    }

    private static class TryCatchBlock {
        Label start;
        Label end;
        Label handler;
        String type;

        public TryCatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

