/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.Map;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCallAdapter
extends MethodVisitor {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectCallAdapter.class);
    Map<String, String> descriptors = null;

    public ObjectCallAdapter(MethodVisitor mv, Map<String, String> descriptors) {
        super(589824, mv);
        this.descriptors = descriptors;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.descriptors.containsKey(name + desc)) {
            logger.info("Replacing call to " + name + desc + " with " + this.descriptors.get(name + desc));
            super.visitMethodInsn(opcode, owner, name, this.descriptors.get(name + desc), itf);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

