/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.evosuite.instrumentation.ObjectCallAdapter;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.utils.FileIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSignatureAdapter
extends ClassVisitor {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectSignatureAdapter.class);
    private final String className;
    private boolean exclude = false;
    private Map<String, String> descriptors = new HashMap<String, String>();

    public ObjectSignatureAdapter(ClassVisitor visitor, String className) {
        super(589824, visitor);
        this.className = ResourceList.getClassNameFromResourcePath(className);
        if (!this.className.startsWith(Properties.PROJECT_PREFIX) && !this.className.startsWith(Properties.TARGET_CLASS_PREFIX)) {
            this.exclude = true;
        } else {
            this.exclude = false;
            File file = new File(Properties.OUTPUT_DIR + "/" + className + ".obj");
            List<String> lines = FileIOUtils.readFile(file);
            this.descriptors = new HashMap<String, String>();
            for (String line : lines) {
                if ((line = line.trim()).startsWith("#")) continue;
                String[] parameters = line.split(",");
                if (parameters.length == 2) {
                    this.descriptors.put(parameters[0], parameters[1]);
                    logger.info("Adding descriptor: " + parameters[1]);
                    continue;
                }
                if (parameters.length != 3) continue;
                this.descriptors.put(parameters[0], parameters[1]);
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        if (!this.exclude) {
            if (this.descriptors.containsKey(name + descriptor)) {
                logger.info("Changing descriptor from " + descriptor + " to " + this.descriptors.get(name + descriptor));
                descriptor = this.descriptors.get(name + descriptor);
            } else {
                logger.info("Couldn't find descriptor from " + name + descriptor);
            }
        }
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        mv = new ObjectCallAdapter(mv, this.descriptors);
        return mv;
    }
}

