/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.coverage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.instrumentation.BooleanValueInterpreter;
import org.evosuite.instrumentation.coverage.MethodInstrumentation;
import org.evosuite.instrumentation.mutation.InsertUnaryOperator;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.evosuite.instrumentation.mutation.ReplaceArithmeticOperator;
import org.evosuite.instrumentation.mutation.ReplaceBitwiseOperator;
import org.evosuite.instrumentation.mutation.ReplaceComparisonOperator;
import org.evosuite.instrumentation.mutation.ReplaceConstant;
import org.evosuite.instrumentation.mutation.ReplaceVariable;
import org.evosuite.runtime.instrumentation.AnnotatedLabel;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;
import org.evosuite.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LabelNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LdcInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Analyzer;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.BasicValue;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Frame;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationInstrumentation
implements MethodInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(MethodInstrumentation.class);
    private final List<MutationOperator> mutationOperators;
    private Frame[] frames = new Frame[0];

    public MutationInstrumentation() {
        this.mutationOperators = new ArrayList<MutationOperator>();
        this.mutationOperators.add(new ReplaceComparisonOperator());
        this.mutationOperators.add(new ReplaceBitwiseOperator());
        this.mutationOperators.add(new ReplaceArithmeticOperator());
        this.mutationOperators.add(new ReplaceVariable());
        this.mutationOperators.add(new ReplaceConstant());
        this.mutationOperators.add(new InsertUnaryOperator());
    }

    private void getFrames(MethodNode mn, String className) {
        try {
            Analyzer<BasicValue> a = new Analyzer<BasicValue>(new BooleanValueInterpreter(mn.desc, (mn.access & 8) == 8));
            a.analyze(className, mn);
            this.frames = a.getFrames();
        }
        catch (Exception e) {
            logger.info("1. Error during analysis: " + e);
        }
    }

    @Override
    public void analyze(ClassLoader classLoader, MethodNode mn, String className, String methodName, int access) {
        if (methodName.startsWith("<clinit>")) {
            return;
        }
        if (methodName.startsWith("__STATIC_RESET")) {
            return;
        }
        RawControlFlowGraph graph = GraphPool.getInstance(classLoader).getRawCFG(className, methodName);
        Iterator j = mn.instructions.iterator();
        this.getFrames(mn, className);
        boolean constructorInvoked = false;
        if (!methodName.startsWith("<init>")) {
            constructorInvoked = true;
        }
        logger.info("Applying mutation operators ");
        int frameIndex = 0;
        int numMutants = 0;
        if (this.frames.length != mn.instructions.size()) {
            logger.error("Number of frames does not match number number of bytecode instructions: " + this.frames.length + "/" + mn.instructions.size());
            logger.error("Skipping mutation of method " + className + "." + methodName);
            return;
        }
        block0: while (j.hasNext()) {
            Frame currentFrame = this.frames[frameIndex++];
            AbstractInsnNode in = (AbstractInsnNode)j.next();
            if (!constructorInvoked) {
                if (in.getOpcode() != 183 || className.matches(".*\\$\\d+$")) continue;
                MethodInsnNode cn = (MethodInsnNode)in;
                HashSet<String> superClasses = new HashSet<String>();
                if (DependencyAnalysis.getInheritanceTree() != null && DependencyAnalysis.getInheritanceTree().hasClass(className)) {
                    superClasses.addAll(DependencyAnalysis.getInheritanceTree().getSuperclasses(className));
                }
                superClasses.add(className);
                String classNameWithDots = ResourceList.getClassNameFromResourcePath(cn.owner);
                if (superClasses.contains(classNameWithDots)) {
                    constructorInvoked = true;
                }
            }
            boolean inInstrumentation = false;
            for (BytecodeInstruction v : graph.vertexSet()) {
                LabelNode labelNode;
                if (v.isLabel() && (labelNode = (LabelNode)v.getASMNode()).getLabel() instanceof AnnotatedLabel) {
                    AnnotatedLabel aLabel = (AnnotatedLabel)labelNode.getLabel();
                    inInstrumentation = aLabel.isStartTag();
                }
                if (inInstrumentation) continue;
                if (in.equals(v.getASMNode())) {
                    logger.info(v.toString());
                    LinkedList<Mutation> mutations = new LinkedList<Mutation>();
                    for (MutationOperator mutationOperator : this.mutationOperators) {
                        if (numMutants++ > Properties.MAX_MUTANTS_PER_METHOD) {
                            logger.info("Reached maximum number of mutants per method");
                            break;
                        }
                        if (!mutationOperator.isApplicable(v)) continue;
                        logger.info("Applying mutation operator " + mutationOperator.getClass().getSimpleName());
                        mutations.addAll(mutationOperator.apply(mn, className, methodName, v, currentFrame));
                    }
                    if (!mutations.isEmpty()) {
                        logger.info("Adding instrumentation for mutation");
                        this.addInstrumentation(mn, in, mutations);
                    }
                }
                if (numMutants <= Properties.MAX_MUTANTS_PER_METHOD) continue;
                continue block0;
            }
        }
        j = mn.instructions.iterator();
        logger.info("Result of mutation: ");
        while (j.hasNext()) {
            AbstractInsnNode in = (AbstractInsnNode)j.next();
            logger.info(new BytecodeInstruction(classLoader, className, methodName, 0, 0, in).toString());
        }
        logger.info("Done.");
    }

    @Override
    public boolean executeOnMainMethod() {
        return false;
    }

    @Override
    public boolean executeOnExcludedMethods() {
        return false;
    }

    protected void addInstrumentation(MethodNode mn, AbstractInsnNode original, List<Mutation> mutations) {
        InsnList instructions = new InsnList();
        for (Mutation mutation : mutations) {
            instructions.add(mutation.getInfectionDistance());
            instructions.add(new LdcInsnNode((Object)mutation.getId()));
            MethodInsnNode touched = new MethodInsnNode(184, Type.getInternalName(ExecutionTracer.class), "passedMutation", Type.getMethodDescriptor(Type.VOID_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE), false);
            instructions.add(touched);
        }
        LabelNode endLabel = new LabelNode();
        for (Mutation mutation : mutations) {
            LabelNode nextLabel = new LabelNode();
            LdcInsnNode mutationId = new LdcInsnNode((Object)mutation.getId());
            instructions.add(mutationId);
            FieldInsnNode activeId = new FieldInsnNode(178, Type.getInternalName(MutationObserver.class), "activeMutation", "I");
            instructions.add(activeId);
            instructions.add(new JumpInsnNode(160, nextLabel));
            instructions.add(mutation.getMutation());
            instructions.add(new JumpInsnNode(167, endLabel));
            instructions.add(nextLabel);
        }
        mn.instructions.insertBefore(original, instructions);
        mn.instructions.insert(original, endLabel);
    }
}

