/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorConditionChecker {
    private static final Logger logger = LoggerFactory.getLogger(ErrorConditionChecker.class);
    protected static final int HALFWAY = 0x3FFFFFFF;

    public static int scale(float value) {
        return 0x7FFFFFFD * (int)Math.ceil(value / (value + 1.0f));
    }

    public static int scale(double value) {
        return 0x7FFFFFFD * (int)Math.ceil(value / (value + 1.0));
    }

    public static int scale(long value) {
        return 0x7FFFFFFD * (int)Math.ceil((double)value / ((double)value + 1.0));
    }

    public static int scaleTo(double value, int max) {
        return (int)Math.ceil((double)max * (1.0 * value / (value + 1.0)));
    }

    public static int overflowDistance(int op1, int op2, int opcode) {
        switch (opcode) {
            case 96: {
                int result = ErrorConditionChecker.overflowDistanceAdd(op1, op2);
                logger.debug("O: " + op1 + " + " + op2 + " = " + (op1 + op2) + " -> " + result);
                return result;
            }
            case 100: {
                return ErrorConditionChecker.overflowDistanceSub(op1, op2);
            }
            case 104: {
                return ErrorConditionChecker.overflowDistanceMul(op1, op2);
            }
            case 108: {
                return ErrorConditionChecker.overflowDistanceDiv(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceAdd(int op1, int op2) {
        int result = op1 + op2;
        if (op1 > 0 && op2 > 0) {
            if (result < 0) {
                return result;
            }
            int retVal = 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
            if (retVal != 0) {
                return retVal;
            }
            return 1;
        }
        if (op1 < 0 && op2 < 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((long)op1) + Math.abs((long)op2), 0x3FFFFFFF);
        }
        if (op1 >= 0 && op2 < 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 >= 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceAdd(int op1, int op2) {
        int result = op1 + op2;
        if (op1 <= 0 && op2 <= 0) {
            if (op1 == Integer.MIN_VALUE && op2 == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return result > 0 ? -result : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(Math.abs((long)result), 0x3FFFFFFF) + 1;
        }
        if (op1 > 0 && op2 > 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((long)op1) + Math.abs((long)op2), 0x3FFFFFFF);
        }
        if (op1 >= 0 && op2 < 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 >= 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceSub(int op1, int op2) {
        int result = op1 - op2;
        if (op1 >= 0 && op2 <= 0) {
            return result < 0 ? result : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 > 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((long)op1) + Math.abs((long)op2), 0x3FFFFFFF);
        }
        if (op1 >= 0 && op2 > 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op2, 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 <= 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((long)op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceSub(int op1, int op2) {
        int result = op1 - op2;
        if (op1 <= 0 && op2 >= 0) {
            return result > 0 ? -result : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0 && op2 < 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((long)op1) + Math.abs((long)op2), 0x3FFFFFFF);
        }
        if (op1 >= 0 && op2 > 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op1, 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 <= 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((long)op2), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int overflowDistanceMul(int op1, int op2) {
        int result = op1 * op2;
        if (op1 > 0 && op2 > 0) {
            long longResult = (long)op1 * (long)op2;
            if (longResult > Integer.MAX_VALUE) {
                if (result <= 0) {
                    return result;
                }
                return Integer.MIN_VALUE;
            }
            int retval = 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
            if (retval > 0) {
                return retval;
            }
            return 1;
        }
        if (op1 < 0 && op2 < 0) {
            return result <= 0 ? result : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0 && op2 < 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 > 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x3FFFFFFF;
    }

    protected static int underflowDistanceMul(int op1, int op2) {
        int result = op1 * op2;
        if (op1 > 0 && op2 < 0) {
            return result >= 0 ? -result : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 > 0) {
            return result >= 0 ? -result : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0 && op2 > 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.min(op1, op2), 0x3FFFFFFF);
        }
        if (op1 < 0 && op2 < 0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(Math.max(op1, op2)), 0x3FFFFFFF);
        }
        return 0x3FFFFFFF;
    }

    protected static int overflowDistanceDiv(int op1, int op2) {
        if (op1 == Integer.MIN_VALUE && op2 == -1) {
            return -1;
        }
        if (op2 == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return ErrorConditionChecker.scaleTo(Math.abs(Integer.MIN_VALUE - op1), 0x3FFFFFFF) + ErrorConditionChecker.scaleTo(Math.abs(-1 - op2), 0x3FFFFFFF);
    }

    public static int underflowDistance(int op1, int op2, int opcode) {
        switch (opcode) {
            case 96: {
                int result = ErrorConditionChecker.underflowDistanceAdd(op1, op2);
                logger.debug("U: " + op1 + " + " + op2 + " = " + (op1 + op2) + " -> " + result);
                return result;
            }
            case 100: {
                return ErrorConditionChecker.underflowDistanceSub(op1, op2);
            }
            case 104: {
                return ErrorConditionChecker.underflowDistanceMul(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int overflowDistance(float op1, float op2, int opcode) {
        switch (opcode) {
            case 98: {
                return ErrorConditionChecker.overflowDistanceAdd(op1, op2);
            }
            case 102: {
                return ErrorConditionChecker.overflowDistanceSub(op1, op2);
            }
            case 106: {
                return ErrorConditionChecker.overflowDistanceMul(op1, op2);
            }
            case 110: {
                return ErrorConditionChecker.overflowDistanceDiv(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int underflowDistance(float op1, float op2, int opcode) {
        switch (opcode) {
            case 98: {
                return ErrorConditionChecker.underflowDistanceAdd(op1, op2);
            }
            case 102: {
                return ErrorConditionChecker.underflowDistanceSub(op1, op2);
            }
            case 106: {
                return ErrorConditionChecker.underflowDistanceMul(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceAdd(float op1, float op2) {
        float result = op1 + op2;
        if (op1 > 0.0f && op2 > 0.0f) {
            return result == Float.POSITIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) + 1;
        }
        if (op1 < 0.0f && op2 < 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo((double)op1 + (double)op2, 0x3FFFFFFF);
        }
        if (op1 >= 0.0f && op2 < 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 >= 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceAdd(float op1, float op2) {
        float result = op1 + op2;
        if (op1 <= 0.0f && op2 <= 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(Math.abs((double)result), 0x3FFFFFFF) + 1;
        }
        if (op1 > 0.0f && op2 > 0.0f) {
            return result == Float.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((double)op1) + Math.abs((double)op2), 0x3FFFFFFF);
        }
        if (op1 >= 0.0f && op2 < 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op1, 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 >= 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op2, 0x3FFFFFFF);
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceSub(float op1, float op2) {
        float result = op1 - op2;
        if (op1 >= 0.0f && op2 <= 0.0f) {
            return result == Float.POSITIVE_INFINITY ? -1 : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 > 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((double)op1) + Math.abs((double)op2), 0x3FFFFFFF);
        }
        if (op1 >= 0.0f && op2 > 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op2, 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 <= 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((double)op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceSub(float op1, float op2) {
        float result = op1 - op2;
        if (op1 <= 0.0f && op2 >= 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? -1 : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0.0f && op2 < 0.0f) {
            return result == Float.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((double)op1) + Math.abs((double)op2), 0x3FFFFFFF);
        }
        if (op1 >= 0.0f && op2 > 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((double)op1), 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 <= 0.0f) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs((double)op2), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int overflowDistanceMul(float op1, float op2) {
        float result = op1 * op2;
        if (op1 > 0.0f && op2 > 0.0f) {
            return result == Float.POSITIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 < 0.0f) {
            return result == Float.POSITIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) + 1;
        }
        if (op1 > 0.0f && op2 < 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 > 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x3FFFFFFF;
    }

    protected static int underflowDistanceMul(float op1, float op2) {
        float result = op1 * op2;
        if (op1 > 0.0f && op2 < 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 > 0.0f) {
            return result == Float.NEGATIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0.0f && op2 > 0.0f) {
            return result == Float.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.min(op1, op2), 0x3FFFFFFF);
        }
        if (op1 < 0.0f && op2 < 0.0f) {
            return result == Float.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(Math.max(op1, op2)), 0x3FFFFFFF);
        }
        return 0x3FFFFFFF;
    }

    protected static int overflowDistanceDiv(float op1, float op2) {
        if (op1 == -3.4028235E38f && (double)op2 == -1.0) {
            return -1;
        }
        return ErrorConditionChecker.scaleTo(Math.abs(-3.4028235E38f - op1), 0x3FFFFFFF) + ErrorConditionChecker.scaleTo(Math.abs(-1.0 - (double)op2), 0x3FFFFFFF);
    }

    public static int overflowDistance(double op1, double op2, int opcode) {
        switch (opcode) {
            case 99: {
                return ErrorConditionChecker.overflowDistanceAdd(op1, op2);
            }
            case 103: {
                return ErrorConditionChecker.overflowDistanceSub(op1, op2);
            }
            case 107: {
                return ErrorConditionChecker.overflowDistanceMul(op1, op2);
            }
            case 111: {
                return ErrorConditionChecker.overflowDistanceDiv(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int underflowDistance(double op1, double op2, int opcode) {
        switch (opcode) {
            case 99: {
                return ErrorConditionChecker.underflowDistanceAdd(op1, op2);
            }
            case 103: {
                return ErrorConditionChecker.underflowDistanceSub(op1, op2);
            }
            case 107: {
                return ErrorConditionChecker.underflowDistanceMul(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceAdd(double op1, double op2) {
        double result = op1 + op2;
        if (op1 > 0.0 && op2 > 0.0) {
            return result == Double.POSITIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) + 1;
        }
        if (op1 < 0.0 && op2 < 0.0) {
            return result == Double.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) + 1;
        }
        if (op1 >= 0.0 && op2 < 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 >= 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceAdd(double op1, double op2) {
        double result = op1 + op2;
        if (op1 <= 0.0 && op2 <= 0.0) {
            return result == Double.NEGATIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(Math.abs(result), 0x3FFFFFFF) + 1;
        }
        if (op1 > 0.0 && op2 > 0.0) {
            return result == Double.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1) + Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 >= 0.0 && op2 < 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op1, 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 >= 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op2, 0x3FFFFFFF);
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceSub(double op1, double op2) {
        double result = op1 - op2;
        if (op1 >= 0.0 && op2 <= 0.0) {
            return result == Double.POSITIVE_INFINITY ? -1 : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 > 0.0) {
            return result == Double.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1) + Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 >= 0.0 && op2 > 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op2, 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 <= 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceSub(double op1, double op2) {
        double result = op1 - op2;
        if (op1 <= 0.0 && op2 >= 0.0) {
            return result == Double.NEGATIVE_INFINITY ? -1 : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0.0 && op2 < 0.0) {
            return result == Double.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1) + Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 >= 0.0 && op2 > 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 <= 0.0) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int overflowDistanceMul(double op1, double op2) {
        double result = op1 * op2;
        if (op1 > 0.0 && op2 > 0.0) {
            return result == Double.POSITIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 < 0.0) {
            return result == Double.POSITIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) + 1;
        }
        if (op1 > 0.0 && op2 < 0.0) {
            return result == Double.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 > 0.0) {
            return result == Double.NEGATIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x3FFFFFFF;
    }

    protected static int underflowDistanceMul(double op1, double op2) {
        double result = op1 * op2;
        if (op1 > 0.0 && op2 < 0.0) {
            return result == Double.NEGATIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 > 0.0) {
            return result == Double.NEGATIVE_INFINITY ? -1 : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0.0 && op2 > 0.0) {
            return result == Double.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.min(op1, op2), 0x3FFFFFFF);
        }
        if (op1 < 0.0 && op2 < 0.0) {
            return result == Double.POSITIVE_INFINITY ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(Math.max(op1, op2)), 0x3FFFFFFF);
        }
        return 0x3FFFFFFF;
    }

    protected static int overflowDistanceDiv(double op1, double op2) {
        if (op1 == -1.7976931348623157E308 && op2 == -1.0) {
            return -1;
        }
        return ErrorConditionChecker.scaleTo(Math.abs(-1.7976931348623157E308 - op1), 0x3FFFFFFF) + ErrorConditionChecker.scaleTo(Math.abs(-1.0 - op2), 0x3FFFFFFF);
    }

    public static int overflowDistance(long op1, long op2, int opcode) {
        switch (opcode) {
            case 97: {
                return ErrorConditionChecker.overflowDistanceAdd(op1, op2);
            }
            case 101: {
                return ErrorConditionChecker.overflowDistanceSub(op1, op2);
            }
            case 105: {
                return ErrorConditionChecker.overflowDistanceMul(op1, op2);
            }
            case 109: {
                return ErrorConditionChecker.overflowDistanceDiv(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int underflowDistance(long op1, long op2, int opcode) {
        switch (opcode) {
            case 97: {
                return ErrorConditionChecker.underflowDistanceAdd(op1, op2);
            }
            case 101: {
                return ErrorConditionChecker.underflowDistanceSub(op1, op2);
            }
            case 105: {
                return ErrorConditionChecker.underflowDistanceMul(op1, op2);
            }
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceAdd(long op1, long op2) {
        long result = op1 + op2;
        if (op1 > 0L && op2 > 0L) {
            return result < 0L ? -ErrorConditionChecker.scaleTo(Math.abs(result), 0x3FFFFFFF) : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) + 1;
        }
        if (op1 < 0L && op2 < 0L) {
            return result > 0L ? Integer.MAX_VALUE : 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) + 1;
        }
        if (op1 >= 0L && op2 < 0L) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0L && op2 >= 0L) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceAdd(long op1, long op2) {
        long result = op1 + op2;
        if (op1 <= 0L && op2 <= 0L) {
            if (result > 0L) {
                int retval = -ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
                if (retval < 0) {
                    return retval;
                }
                return -1;
            }
            if (result == 0L) {
                if (op1 != 0L && op2 != 0L) {
                    return -1;
                }
                return 0x3FFFFFFF - ErrorConditionChecker.scaleTo(Math.abs(result), 0x3FFFFFFF);
            }
            int intResult = 0x3FFFFFFF - ErrorConditionChecker.scaleTo(Math.abs(result), 0x3FFFFFFF);
            if (intResult == 0) {
                return 1;
            }
            return intResult;
        }
        if (op1 > 0L && op2 > 0L) {
            return result < 0L ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1) + Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 >= 0L && op2 < 0L) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op1, 0x3FFFFFFF);
        }
        if (op1 < 0L && op2 >= 0L) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op2, 0x3FFFFFFF);
        }
        return Integer.MAX_VALUE;
    }

    protected static int overflowDistanceSub(long op1, long op2) {
        long result = op1 - op2;
        if (op1 >= 0L && op2 <= 0L) {
            return result < 0L ? -ErrorConditionChecker.scaleTo(Math.abs(result), 0x3FFFFFFF) : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 < 0L && op2 > 0L) {
            return result > 0L ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1) + Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 >= 0L && op2 > 0L) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(op2, 0x3FFFFFFF);
        }
        if (op1 < 0L && op2 <= 0L) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int underflowDistanceSub(long op1, long op2) {
        long result = op1 - op2;
        if (op1 <= 0L && op2 >= 0L) {
            return result > 0L ? -ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF) : 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        }
        if (op1 > 0L && op2 < 0L) {
            return result < 0L ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1) + Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 >= 0L && op2 > 0L) {
            return 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        if (op1 < 0L && op2 <= 0L) {
            return 0x40000000 + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        return 0x40000000 - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
    }

    protected static int overflowDistanceMul(long op1, long op2) {
        long result = op1 * op2;
        if (op1 > 0L && op2 > 0L || op1 < 0L && op2 < 0L) {
            BigDecimal maxResult;
            BigDecimal bigDecimal = new BigDecimal(op1).multiply(new BigDecimal(op2));
            if (bigDecimal.compareTo(maxResult = new BigDecimal(Long.MAX_VALUE)) > 0) {
                int intResult = -ErrorConditionChecker.scaleTo(Math.abs(result), 0x3FFFFFFF);
                if (result <= 0L) {
                    return intResult;
                }
                return Integer.MIN_VALUE;
            }
            int retval = 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
            if (retval > 0) {
                return retval;
            }
            return 1;
        }
        if (op1 > 0L && op2 < 0L) {
            return result > 0L ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op2), 0x3FFFFFFF);
        }
        if (op1 < 0L && op2 > 0L) {
            return result > 0L ? Integer.MAX_VALUE : 0x3FFFFFFF + ErrorConditionChecker.scaleTo(Math.abs(op1), 0x3FFFFFFF);
        }
        return 0x3FFFFFFF;
    }

    protected static int underflowDistanceMul(long op1, long op2) {
        BigDecimal minResult;
        long result = op1 * op2;
        BigDecimal bigDecimal = new BigDecimal(op1).multiply(new BigDecimal(op2));
        if (bigDecimal.compareTo(minResult = new BigDecimal(Long.MIN_VALUE)) < 0) {
            int intResult = -ErrorConditionChecker.scaleTo(Math.abs(result), 0x3FFFFFFF);
            if (result <= 0L) {
                return intResult;
            }
            return Integer.MIN_VALUE;
        }
        int retval = 0x3FFFFFFF - ErrorConditionChecker.scaleTo(result, 0x3FFFFFFF);
        if (retval > 0) {
            return retval;
        }
        return 1;
    }

    protected static int overflowDistanceDiv(long op1, long op2) {
        if (op1 == Long.MIN_VALUE && op2 == -1L) {
            return -1;
        }
        return ErrorConditionChecker.scaleTo(Math.abs(Long.MIN_VALUE - op1), 0x3FFFFFFF) + ErrorConditionChecker.scaleTo(Math.abs(-1L - op2), 0x3FFFFFFF);
    }
}

