/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;
import org.evosuite.instrumentation.error.ErrorConditionMethodAdapter;

public class QueueInstrumentation
extends ErrorBranchInstrumenter {
    private static final List<String> LISTNAMES = Arrays.asList(Queue.class.getCanonicalName().replace('.', '/'), PriorityQueue.class.getCanonicalName().replace('.', '/'), Deque.class.getCanonicalName().replace('.', '/'), LinkedBlockingDeque.class.getCanonicalName().replace('.', '/'), BlockingDeque.class.getCanonicalName().replace('.', '/'), ArrayDeque.class.getCanonicalName().replace('.', '/'));
    private final List<String> emptyListMethods = Arrays.asList("remove", "element");

    public QueueInstrumentation(ErrorConditionMethodAdapter mv) {
        super(mv);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (LISTNAMES.contains(owner) && this.emptyListMethods.contains(name)) {
            Map<Integer, Integer> tempVariables = this.getMethodCallee(desc);
            this.tagBranchStart();
            this.mv.visitMethodInsn(182, owner, "isEmpty", "()Z", false);
            this.insertBranch(158, "java/util/NoSuchElementException");
            this.tagBranchEnd();
            this.restoreMethodParameters(tempVariables, desc);
        }
    }
}

