/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;
import org.evosuite.instrumentation.error.ErrorConditionMethodAdapter;

public class StackInstrumentation
extends ErrorBranchInstrumenter {
    private static final String LISTNAME = Stack.class.getCanonicalName().replace('.', '/');
    private final List<String> emptyStackMethods = Arrays.asList("pop", "peek");

    public StackInstrumentation(ErrorConditionMethodAdapter mv) {
        super(mv);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (owner.equals(LISTNAME) && this.emptyStackMethods.contains(name)) {
            Map<Integer, Integer> tempVariables = this.getMethodCallee(desc);
            this.tagBranchStart();
            this.mv.visitMethodInsn(182, LISTNAME, "empty", "()Z", false);
            this.insertBranch(158, "java/util/EmptyStackException");
            this.tagBranchEnd();
            this.restoreMethodParameters(tempVariables, desc);
        }
    }
}

